/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.ViableConversion;
import com.documents4j.conversion.msoffice.AbstractMicrosoftOfficeBridge;
import com.documents4j.conversion.msoffice.MicrosoftOfficeScript;
import com.documents4j.conversion.msoffice.MicrosoftOfficeTargetNameCorrector;
import com.documents4j.conversion.msoffice.MicrosoftPowerpointFormat;
import com.documents4j.conversion.msoffice.MicrosoftPowerpointScript;
import com.documents4j.conversion.msoffice.MicrosoftPowerpointTargetNameCorrectorAndLockManager;
import com.documents4j.util.OsUtils;
import java.io.File;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ViableConversion(from={"application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.com.documents4j.any-mspowerpoint"}, to={"application/pdf", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation"})
public class MicrosoftPowerpointBridge
extends AbstractMicrosoftOfficeBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftPowerpointBridge.class);
    private static final Object POWERPOINT_LOCK = new Object();
    private static final Semaphore CONVERSION_LOCK = new Semaphore(3, true);

    public MicrosoftPowerpointBridge(File baseFolder, long processTimeout, TimeUnit processTimeoutUnit) {
        super(baseFolder, processTimeout, processTimeoutUnit, (MicrosoftOfficeScript)MicrosoftPowerpointScript.CONVERSION, OsUtils.isMac());
        this.startUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUp() {
        Object object = POWERPOINT_LOCK;
        synchronized (object) {
            this.tryStart(MicrosoftPowerpointScript.STARTUP);
            LOGGER.info("From-Microsoft-Powerpoint-Converter was started successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Object object = POWERPOINT_LOCK;
        synchronized (object) {
            this.tryStop(MicrosoftPowerpointScript.SHUTDOWN);
            LOGGER.info("From-Microsoft-Powerpoint-Converter was shut down successfully");
        }
    }

    protected MicrosoftOfficeTargetNameCorrector targetNameCorrector(File target, String fileExtension) {
        return new MicrosoftPowerpointTargetNameCorrectorAndLockManager(target, fileExtension, CONVERSION_LOCK, LOGGER);
    }

    protected MicrosoftPowerpointFormat formatOf(DocumentType documentType) {
        return MicrosoftPowerpointFormat.of(documentType);
    }

    protected MicrosoftOfficeScript getAssertionScript() {
        return MicrosoftPowerpointScript.ASSERTION;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

