/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.IExternalConverter;
import com.documents4j.conversion.ViableConversion;
import com.documents4j.conversion.ViableConversions;
import com.documents4j.throwables.ConversionInputException;
import com.documents4j.throwables.ConverterException;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ConverterRegistry {
    private final Set<? extends IExternalConverter> externalConverters;
    private final Map<ConversionPath, IExternalConverter> converterMapping;
    private final Map<DocumentType, Set<DocumentType>> supportedConversions;

    public ConverterRegistry(Set<? extends IExternalConverter> externalConverters) {
        this.externalConverters = externalConverters;
        this.converterMapping = new HashMap<ConversionPath, IExternalConverter>();
        for (IExternalConverter iExternalConverter : externalConverters) {
            this.converterMapping.putAll(ConverterRegistry.resolve(iExternalConverter));
        }
        this.supportedConversions = ConverterRegistry.extractSupportedConversions(this.converterMapping.keySet());
    }

    private static Map<DocumentType, Set<DocumentType>> extractSupportedConversions(Set<ConversionPath> conversionPaths) {
        HashMap<DocumentType, Set<DocumentType>> supported = new HashMap<DocumentType, Set<DocumentType>>();
        for (ConversionPath conversionPath : conversionPaths) {
            Set targetFormat = supported.computeIfAbsent(conversionPath.getSourceFormat(), k -> new HashSet());
            targetFormat.add(conversionPath.getTargetFormat());
        }
        return supported;
    }

    private static Map<ConversionPath, IExternalConverter> resolve(IExternalConverter externalConverter) {
        ViableConversion[] viableConversionArray;
        boolean viableConversionPresent = externalConverter.getClass().isAnnotationPresent(ViableConversion.class);
        boolean viableConversionsPresent = externalConverter.getClass().isAnnotationPresent(ViableConversions.class);
        Preconditions.checkState((boolean)(viableConversionPresent ^ viableConversionsPresent), (Object)(externalConverter + " must be annotated with exactly one of @ViableConversion or @ViableConversions"));
        if (viableConversionPresent) {
            ViableConversion[] viableConversionArray2 = new ViableConversion[1];
            viableConversionArray = viableConversionArray2;
            viableConversionArray2[0] = externalConverter.getClass().getAnnotation(ViableConversion.class);
        } else {
            viableConversionArray = externalConverter.getClass().getAnnotation(ViableConversions.class).value();
        }
        ViableConversion[] viableConversions = viableConversionArray;
        HashMap<ConversionPath, IExternalConverter> conversionMapping = new HashMap<ConversionPath, IExternalConverter>();
        for (ViableConversion viableConversion : viableConversions) {
            for (String sourceFormat : viableConversion.from()) {
                for (String targetFormat : viableConversion.to()) {
                    conversionMapping.put(new ConversionPath(new DocumentType(sourceFormat), new DocumentType(targetFormat)), externalConverter);
                }
            }
        }
        return conversionMapping;
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return Collections.unmodifiableMap(this.supportedConversions);
    }

    public IExternalConverter lookup(DocumentType sourceFormat, DocumentType targetFormat) {
        IExternalConverter externalConverter = this.converterMapping.get(new ConversionPath(sourceFormat, targetFormat));
        if (externalConverter == null) {
            throw new ConversionInputException("No converter for conversion of " + sourceFormat + " to " + targetFormat + " available");
        }
        return externalConverter;
    }

    public boolean isOperational() {
        for (IExternalConverter iExternalConverter : this.externalConverters) {
            if (iExternalConverter.isOperational()) continue;
            return false;
        }
        return true;
    }

    public void shutDown() {
        HashSet<RuntimeException> runtimeExceptions = new HashSet<RuntimeException>();
        for (IExternalConverter iExternalConverter : this.externalConverters) {
            try {
                iExternalConverter.shutDown();
            }
            catch (RuntimeException e) {
                runtimeExceptions.add(e);
            }
        }
        if (runtimeExceptions.size() > 0) {
            throw new ConverterException("Could not shut down at least one external converter: " + runtimeExceptions);
        }
    }

    private static class ConversionPath {
        private final DocumentType sourceFormat;
        private final DocumentType targetFormat;

        private ConversionPath(DocumentType sourceFormat, DocumentType targetFormat) {
            this.sourceFormat = sourceFormat;
            this.targetFormat = targetFormat;
        }

        public DocumentType getSourceFormat() {
            return this.sourceFormat;
        }

        public DocumentType getTargetFormat() {
            return this.targetFormat;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ConversionPath conversionPath = (ConversionPath)other;
            return this.sourceFormat.equals((Object)conversionPath.sourceFormat) && this.targetFormat.equals((Object)conversionPath.targetFormat);
        }

        public int hashCode() {
            int result = this.sourceFormat.hashCode();
            result = 31 * result + this.targetFormat.hashCode();
            return result;
        }
    }
}

