/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.anon;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.math.CTOMathPara;
import org.docx4j.openpackaging.parts.Part;

public class AnonymizeResult {
    public boolean hasGreek = false;
    public boolean hasCyrillic = false;
    public boolean hasHebrew = false;
    public boolean hasArabic = false;
    public boolean hasHiragana = false;
    public boolean hasKatakana = false;
    public boolean hasCJK = false;
    HashSet<Part> unsafeParts;
    HashMap<Part, Set<Object>> unsafeObjectsByPart = new HashMap();
    boolean anyUnsafeObjects = false;
    HashMap<Part, Set<Object>> inventoryObjectsByPart = new HashMap();
    boolean containsVML = false;
    HashSet<String> fieldsPresent = null;

    public HashSet<Part> getUnsafeParts() {
        return this.unsafeParts;
    }

    public HashMap<Part, Set<Object>> getUnsafeObjectsByPart() {
        return this.unsafeObjectsByPart;
    }

    public boolean hasAnyUnsafeObjects() {
        return this.anyUnsafeObjects;
    }

    public HashMap<Part, Set<Object>> getInventoryObjectsByPart() {
        return this.inventoryObjectsByPart;
    }

    public boolean containsVML() {
        return this.containsVML;
    }

    public HashSet<String> getFieldsPresent() {
        return this.fieldsPresent;
    }

    public boolean isOK() {
        return this.unsafeParts.size() == 0 && !this.anyUnsafeObjects;
    }

    public String reportUnsafeObjects() {
        StringBuilder sb = new StringBuilder();
        if (this.hasAnyUnsafeObjects()) {
            sb.append("The following objects may leak info: \n");
            for (Map.Entry<Part, Set<Object>> entry : this.getUnsafeObjectsByPart().entrySet()) {
                Part p = entry.getKey();
                if (entry.getValue().isEmpty()) continue;
                sb.append(p.getPartName().getName() + ", of type " + p.getClass().getName() + "\n");
                for (Object o : entry.getValue()) {
                    if (o instanceof String) {
                        sb.append(o + "\n");
                        continue;
                    }
                    if (o instanceof CTOMathPara) {
                        sb.append("math\n");
                        continue;
                    }
                    sb.append(o.getClass().getName());
                    try {
                        sb.append(XmlUtils.marshaltoString((Object)o) + "\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sb.toString();
    }
}

