/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.anon;

import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.docx4j.TraversalUtil;
import org.docx4j.anon.AnonymizeResult;
import org.docx4j.anon.DmlVmlAnalyzer;
import org.docx4j.anon.PartsAnalyzer;
import org.docx4j.anon.ScrambleText;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageTiffPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Anonymize {
    private static Logger log = LoggerFactory.getLogger(Anonymize.class);
    private WordprocessingMLPackage pkg;
    ScrambleText latinizer = null;
    DmlVmlAnalyzer dmlVmlAnalyzer = null;
    AnonymizeResult result;
    private static byte[] PNG_IMAGE_DATA = Base64.decodeBase64((String)"iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC");
    private static byte[] GIF_IMAGE_DATA = Base64.decodeBase64((String)"R0lGODdhAgACAKEEAAMA//8AAAD/Bv/8ACwAAAAAAgACAAACAww0BQA7");
    private static byte[] JPEG_IMAGE_DATA = Base64.decodeBase64((String)"/9j/4AAQSkZJRgABAQEASABIAAD/4QCMRXhpZgAATU0AKgAAAAgABwEaAAUAAAABAAAAYgEbAAUAAAABAAAAagEoAAMAAAABAAIAAAExAAIAAAASAAAAclEQAAEAAAABAQAAAFERAAQAAAABAAALE1ESAAQAAAABAAALEwAAAAAAARlIAAAD6AABGUgAAAPoUGFpbnQuTkVUIHYzLjUuMTAA/9sAQwACAQECAQECAgICAgICAgMFAwMDAwMGBAQDBQcGBwcHBgcHCAkLCQgICggHBwoNCgoLDAwMDAcJDg8NDA4LDAwM/9sAQwECAgIDAwMGAwMGDAgHCAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwM/8AAEQgAAgACAwEiAAIRAQMRAf/EAB8AAAEFAQEBAQEBAAAAAAAAAAABAgMEBQYHCAkKC//EALUQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+v/EAB8BAAMBAQEBAQEBAQEAAAAAAAABAgMEBQYHCAkKC//EALURAAIBAgQEAwQHBQQEAAECdwABAgMRBAUhMQYSQVEHYXETIjKBCBRCkaGxwQkjM1LwFWJy0QoWJDThJfEXGBkaJicoKSo1Njc4OTpDREVGR0hJSlNUVVZXWFlaY2RlZmdoaWpzdHV2d3h5eoKDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uLj5OXm5+jp6vLz9PX29/j5+v/aAAwDAQACEQMRAD8A/QL4W/sD/ArXfhl4dvr74K/CW8vbzS7ae4uJ/CGnySzyNErM7sYiWYkkknkk0UUV5+U/7jR/wR/JHRP4mf/Z");
    private static byte[] BMP_IMAGE_DATA = Base64.decodeBase64((String)"Qk1GAAAAAAAAADYAAAAoAAAAAgAAAAIAAAABABgAAAAAAAAAAAATCwAAEwsAAAAAAAAAAAAABv8AAPz///8AAP//AAMD/w==");
    private static byte[] TIF_IMAGE_DATA = Base64.decodeBase64((String)"");

    public Anonymize(WordprocessingMLPackage wordMLPackage) {
        this.pkg = wordMLPackage;
        this.result = new AnonymizeResult();
    }

    public AnonymizeResult go() throws Docx4JException {
        this.filterMDPRels();
        this.handleMetadata();
        this.result.unsafeParts = PartsAnalyzer.identifyUnsafeParts(this.pkg.getParts().getParts().entrySet());
        this.detectDmlVmlContent();
        this.applyScrambleCallbackToParts();
        this.handleImages();
        return this.result;
    }

    private void filterMDPRels() {
        if (this.pkg.getMainDocumentPart().getRelationshipsPart() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            for (Relationship r : this.pkg.getMainDocumentPart().getRelationshipsPart().getRelationships().getRelationship()) {
                System.out.println(r.getType());
            }
        }
        this.pkg.getMainDocumentPart().getRelationshipsPart().removeRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml");
        this.pkg.getMainDocumentPart().getRelationshipsPart().removeRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/glossaryDocument");
        this.pkg.getMainDocumentPart().getRelationshipsPart().removeRelationshipsByType("http://schemas.microsoft.com/office/2007/relationships/stylesWithEffects");
    }

    protected void handleMetadata() throws Docx4JException {
        if (this.pkg.getDocPropsExtendedPart() != null && this.pkg.getDocPropsExtendedPart().getContents() != null) {
            ((Properties)this.pkg.getDocPropsExtendedPart().getContents()).setCompany(null);
            ((Properties)this.pkg.getDocPropsExtendedPart().getContents()).setManager(null);
            ((Properties)this.pkg.getDocPropsExtendedPart().getContents()).setHeadingPairs(null);
        }
        if (this.pkg.getDocPropsCorePart() != null && this.pkg.getDocPropsCorePart().getContents() != null) {
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setCategory(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setCreator(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setDescription(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setIdentifier(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setKeywords(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setSubject(null);
            ((CoreProperties)this.pkg.getDocPropsCorePart().getContents()).setTitle(null);
        }
        if (this.pkg.getDocPropsCustomPart() != null) {
            this.pkg.getRelationshipsPart().removePart(this.pkg.getDocPropsCustomPart().getPartName());
        }
        this.pkg.getRelationshipsPart().removePart(new PartName("/docProps/thumbnail.emf"));
    }

    private void handleImages() throws InvalidFormatException {
        for (Map.Entry entry : this.pkg.getParts().getParts().entrySet()) {
            Part p = (Part)entry.getValue();
            if (!(p instanceof ImagePngPart) && !(p instanceof ImageGifPart) && !(p instanceof ImageJpegPart) && !(p instanceof ImageBmpPart) && !(p instanceof ImageTiffPart)) continue;
            ((BinaryPart)p).setBinaryData(PNG_IMAGE_DATA);
        }
    }

    private void detectDmlVmlContent() throws InvalidFormatException {
        this.dmlVmlAnalyzer = new DmlVmlAnalyzer();
        this.detectDmlVml((JaxbXmlPart)this.pkg.getMainDocumentPart());
        for (Map.Entry entry : this.pkg.getParts().getParts().entrySet()) {
            Part p = (Part)entry.getValue();
            if (p instanceof HeaderPart) {
                this.detectDmlVml((JaxbXmlPart)((HeaderPart)p));
            }
            if (!(p instanceof FooterPart)) continue;
            this.detectDmlVml((JaxbXmlPart)((FooterPart)p));
        }
        if (this.pkg.getMainDocumentPart().getFootnotesPart() != null) {
            this.detectDmlVml((JaxbXmlPart)this.pkg.getMainDocumentPart().getFootnotesPart());
        }
        if (this.pkg.getMainDocumentPart().getEndNotesPart() != null) {
            this.detectDmlVml((JaxbXmlPart)this.pkg.getMainDocumentPart().getEndNotesPart());
        }
        if (this.pkg.getMainDocumentPart().getCommentsPart() != null) {
            this.detectDmlVml((JaxbXmlPart)this.pkg.getMainDocumentPart().getCommentsPart());
        }
    }

    public void detectDmlVml(JaxbXmlPart p) {
        log.info("\n\n Inspecting " + p.getPartName().getName());
        this.dmlVmlAnalyzer.reinit();
        this.dmlVmlAnalyzer.setPart(p);
        new TraversalUtil(p.getJaxbElement(), (TraversalUtil.Callback)this.dmlVmlAnalyzer);
        this.result.unsafeObjectsByPart.put((Part)p, this.dmlVmlAnalyzer.unsafeObjects);
        if (this.dmlVmlAnalyzer.unsafeObjects.size() > 0) {
            this.result.anyUnsafeObjects = true;
        }
        this.result.inventoryObjectsByPart.put((Part)p, this.dmlVmlAnalyzer.inventoryObjects);
        if (!this.result.containsVML) {
            this.result.containsVML = this.dmlVmlAnalyzer.containsVML;
        }
        this.result.fieldsPresent = this.dmlVmlAnalyzer.fieldsPresent;
    }

    private void applyScrambleCallbackToParts() throws InvalidFormatException {
        try {
            this.latinizer = new ScrambleText(this.pkg);
            this.scramble((JaxbXmlPart)this.pkg.getMainDocumentPart());
            for (Map.Entry entry : this.pkg.getParts().getParts().entrySet()) {
                Part p = (Part)entry.getValue();
                if (p instanceof HeaderPart) {
                    this.scramble((JaxbXmlPart)((HeaderPart)p));
                }
                if (!(p instanceof FooterPart)) continue;
                this.scramble((JaxbXmlPart)((FooterPart)p));
            }
            if (this.pkg.getMainDocumentPart().getFootnotesPart() != null) {
                this.scramble((JaxbXmlPart)this.pkg.getMainDocumentPart().getFootnotesPart());
            }
            if (this.pkg.getMainDocumentPart().getEndNotesPart() != null) {
                this.scramble((JaxbXmlPart)this.pkg.getMainDocumentPart().getEndNotesPart());
            }
            if (this.pkg.getMainDocumentPart().getCommentsPart() != null) {
                this.scramble((JaxbXmlPart)this.pkg.getMainDocumentPart().getCommentsPart());
            }
            this.result.hasGreek = this.latinizer.hasGreek;
            this.result.hasCyrillic = this.latinizer.hasCyrillic;
            this.result.hasHebrew = this.latinizer.hasHebrew;
            this.result.hasArabic = this.latinizer.hasArabic;
            this.result.hasHiragana = this.latinizer.hasHiragana;
            this.result.hasKatakana = this.latinizer.hasKatakana;
            this.result.hasCJK = this.latinizer.hasCJK;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidFormatException(e.getMessage(), e);
        }
    }

    public void scramble(JaxbXmlPart p) {
        log.info("\n\n Scrambling " + p.getPartName().getName());
        new TraversalUtil(p.getJaxbElement(), (TraversalUtil.Callback)this.latinizer);
    }
}

