/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.config.WhiteSpaceProcessing;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.IgnorableSpaceEvent;
import com.topologi.diffx.event.impl.SpaceEvent;
import com.topologi.diffx.event.impl.WordEvent;
import com.topologi.diffx.load.text.TextTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TokenizerByWord
implements TextTokenizer {
    private final Map<String, TextEvent> recycling = new HashMap<String, TextEvent>();
    private final WhiteSpaceProcessing whitespace;

    public TokenizerByWord(WhiteSpaceProcessing whitespace) {
        if (whitespace == null) {
            throw new NullPointerException("the white space processing must be specified.");
        }
        this.whitespace = whitespace;
    }

    @Override
    public List<TextEvent> tokenize(CharSequence seq) {
        String word;
        if (seq == null) {
            return null;
        }
        if (seq.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TextEvent> events = new ArrayList<TextEvent>(seq.length());
        Pattern p = Pattern.compile("\\s+");
        Matcher m = p.matcher(seq);
        int index = 0;
        while (m.find()) {
            if (index != m.start()) {
                word = seq.subSequence(index, m.start()).toString();
                events.add(this.getWordEvent(word));
            }
            if (this.whitespace != WhiteSpaceProcessing.IGNORE) {
                String space = seq.subSequence(m.start(), m.end()).toString();
                events.add(this.getSpaceEvent(space));
            }
            index = m.end();
        }
        if (index != seq.length()) {
            word = seq.subSequence(index, seq.length()).toString();
            events.add(this.getWordEvent(word));
        }
        return events;
    }

    @Override
    public TextGranularity granurality() {
        return TextGranularity.WORD;
    }

    private TextEvent getWordEvent(String word) {
        TextEvent e = this.recycling.get(word);
        if (e == null) {
            e = new WordEvent(word);
            this.recycling.put(word, e);
        }
        return e;
    }

    private TextEvent getSpaceEvent(String space) {
        TextEvent e = this.recycling.get(space);
        if (e == null) {
            e = this.whitespace == WhiteSpaceProcessing.PRESERVE ? new IgnorableSpaceEvent(space) : SpaceEvent.getInstance(space);
            this.recycling.put(space, e);
        }
        return e;
    }
}

