/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class FetchGroupMonitor {
    public static Hashtable fetchedAttributes = new Hashtable();
    public static Boolean shouldMonitor;

    public static boolean shouldMonitor() {
        if (shouldMonitor == null) {
            shouldMonitor = Boolean.FALSE;
            String property = PrivilegedAccessHelper.getSystemProperty("org.eclipse.persistence.fetchgroupmonitor");
            if (property != null && property.toUpperCase().equals("TRUE")) {
                shouldMonitor = Boolean.TRUE;
            }
        }
        return shouldMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordFetchedAttribute(Class domainClass, String attributeName) {
        if (!FetchGroupMonitor.shouldMonitor()) {
            return;
        }
        Hashtable hashtable = fetchedAttributes;
        synchronized (hashtable) {
            HashSet<String> classesFetchedAttributes = (HashSet<String>)fetchedAttributes.get(domainClass);
            if (classesFetchedAttributes == null) {
                classesFetchedAttributes = new HashSet<String>();
                fetchedAttributes.put(domainClass, classesFetchedAttributes);
            }
            if (!classesFetchedAttributes.contains(attributeName)) {
                classesFetchedAttributes.add(attributeName);
            }
        }
    }
}

