/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.style.derived;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.Idents;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.LengthValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FSLinearGradientUtil {
    static float deg2rad(float deg) {
        return (float)Math.toRadians(deg);
    }

    static boolean isLengthOrPercentage(PropertyValue value) {
        return AbstractPropertyBuilder.isLengthHelper(value) || value.getPrimitiveType() == 2;
    }

    static int getStopsStartIndex(List<PropertyValue> params) {
        if (Objects.equals(params.get(0).getStringValue(), "to")) {
            int i;
            for (i = 1; i < params.size() && params.get(i).getStringValue() != null && Idents.looksLikeABGPosition(params.get(i).getStringValue()); ++i) {
            }
            return i;
        }
        return 1;
    }

    static float get100PercentDefaultStopLength(CalculatedStyle style, CssContext ctx, float boxWidth) {
        return LengthValue.calcFloatProportionalValue(style, CSSName.BACKGROUND_IMAGE, "100%", 100.0f, (short)2, boxWidth, ctx);
    }

    static float calculateAngle(List<PropertyValue> params, int stopsStartIndex) {
        if (Objects.equals(params.get(0).getStringValue(), "to")) {
            ArrayList<String> positions = new ArrayList<String>(2);
            for (int i = 1; i < stopsStartIndex; ++i) {
                positions.add(params.get(i).getStringValue());
            }
            if (positions.contains("top") && positions.contains("left")) {
                return 315.0f;
            }
            if (positions.contains("top") && positions.contains("right")) {
                return 45.0f;
            }
            if (positions.contains("bottom") && positions.contains("left")) {
                return 225.0f;
            }
            if (positions.contains("bottom") && positions.contains("right")) {
                return 135.0f;
            }
            if (positions.contains("bottom")) {
                return 180.0f;
            }
            if (positions.contains("left")) {
                return 270.0f;
            }
            if (positions.contains("right")) {
                return 90.0f;
            }
            return 0.0f;
        }
        if (params.get(0).getPrimitiveType() == 11) {
            return params.get(0).getFloatValue();
        }
        if (params.get(0).getPrimitiveType() == 12) {
            return params.get(0).getFloatValue() * 57.29578f;
        }
        return 0.0f;
    }
}

