/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.concurrent.ExecutionException;
import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSymbolWriter;
import org.docx4j.convert.out.common.writer.SymbolMapper;
import org.docx4j.convert.out.common.writer.SymbolUtils;
import org.docx4j.fonts.GlyphCheck;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends AbstractSymbolWriter {
    private static final Logger log = LoggerFactory.getLogger(SymbolWriter.class);
    private static final boolean USE_UNICODE_SYMBOL_REPLACEMENTS = true;

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        PhysicalFont pf2;
        PhysicalFont pf;
        R.Sym modelData = (R.Sym)unmarshalledNode;
        String fontName = modelData.getFont();
        String textValue = modelData.getChar();
        boolean haveUnicodeReplacement = false;
        if (fontName.equals("Symbol")) {
            pf = PhysicalFonts.getSymbolFont();
            pf2 = null;
        } else {
            pf = PhysicalFonts.getWDingsFont();
            pf2 = PhysicalFonts.getWDingsFont2();
        }
        if (pf != null) {
            byte[] valBytes = SymbolUtils.hexStringToByteArray((String)textValue);
            assert (valBytes.length <= 2);
            if (valBytes.length == 2 && 61440 <= SymbolUtils.short2Int((byte[])valBytes) && 65535 >= SymbolUtils.short2Int((byte[])valBytes)) {
                valBytes[0] = (byte)(valBytes[0] - 240);
                int nonZeroIdx = -1;
                for (int i = 0; i < valBytes.length; ++i) {
                    if (valBytes[i] == 0) continue;
                    nonZeroIdx = i;
                    break;
                }
                int codePoint = SymbolUtils.short2Int((byte[])valBytes);
                if (nonZeroIdx != -1) {
                    textValue = SymbolMapper.getUnicodeReplacementChar((String)fontName, (short)((short)codePoint));
                    if (textValue != null) {
                        haveUnicodeReplacement = true;
                        try {
                            if (!GlyphCheck.hasCodepoint((PhysicalFont)pf, (int)textValue.codePointAt(0))) {
                                if (pf2 != null && GlyphCheck.hasCodepoint((PhysicalFont)pf2, (int)textValue.codePointAt(0))) {
                                    pf = pf2;
                                    log.debug("For " + fontName + " mapped to " + textValue.codePointAt(0) + ", using 2nd substitute font " + pf2.getName());
                                } else {
                                    log.warn("Missing symbol " + fontName + " " + codePoint + " in substitute font " + pf.getName());
                                }
                            }
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                    if (!haveUnicodeReplacement) {
                        textValue = "\u25a1";
                        if (log.isDebugEnabled()) {
                            if (fontName.equals("Symbol") && codePoint >= 127 && codePoint <= 160) {
                                log.debug("Symbol does not contain " + codePoint + "; why is this in the docx?");
                            } else {
                                log.debug("Missing symbol " + fontName + " " + codePoint);
                            }
                        }
                    }
                } else {
                    textValue = "";
                }
            } else {
                int codePoint = SymbolUtils.short2Int((byte[])valBytes);
                textValue = Character.toString(codePoint);
            }
        } else {
            char chValue = '\u0000';
            Typeface typeface = null;
            pf = context.getWmlPackage().getFontMapper().get(fontName);
            if (pf != null && (typeface = pf.getTypeface()) != null) {
                if (textValue.length() > 1) {
                    try {
                        chValue = (char)Integer.parseInt(textValue, 16);
                    }
                    catch (NumberFormatException nfe) {
                        chValue = '\u0000';
                    }
                } else {
                    chValue = textValue.charAt(0);
                }
                if (chValue != '\u0000') {
                    if (chValue > '\uf000') {
                        chValue = (char)(chValue - 61440);
                    }
                    if (typeface.mapChar(chValue) == '\u0000' && typeface.mapChar(chValue = (char)(chValue + 61440)) == '\u0000') {
                        chValue = '\u0000';
                    }
                    if (chValue != '\u0000') {
                        textValue = Character.toString(chValue);
                    }
                }
            }
        }
        Text theChar = doc.createTextNode(textValue);
        DocumentFragment docfrag = doc.createDocumentFragment();
        if (haveUnicodeReplacement) {
            Element foInline = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            docfrag.appendChild(foInline);
            foInline.setAttribute("font-family", pf.getName());
            foInline.appendChild(theChar);
        } else if (pf == null) {
            log.warn("No physical font present for:" + fontName);
            docfrag.appendChild(theChar);
        } else {
            Element foInline = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            docfrag.appendChild(foInline);
            foInline.setAttribute("font-family", pf.getName());
            foInline.appendChild(theChar);
        }
        return docfrag;
    }
}

