/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.util;

import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.docx4j.Docx4jProperties;
import org.docx4j.convert.out.fopconf.Fonts;
import org.docx4j.convert.out.fopconf.Fop;
import org.docx4j.convert.out.fopconf.ObjectFactory;
import org.docx4j.convert.out.fopconf.Substitutions;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FopConfigUtil {
    protected static Logger log = LoggerFactory.getLogger(FopConfigUtil.class);
    private static Substitutions substitutions = null;
    private static ObjectFactory factory = null;

    public static Fop createConfigurationObject(Mapper fontMapper, Set<String> fontsInUse) throws Docx4JException {
        log.debug("Config object");
        Fop fopConfig = factory.createFop();
        fopConfig.setVersion("1.0");
        fopConfig.setStrictConfiguration(true);
        if (substitutions != null) {
            Fop.Fonts fonts = factory.createFopFonts();
            fopConfig.setFonts(fonts);
            fonts.setSubstitutions(substitutions);
        } else {
            log.debug("No font substitutions provided at " + Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.substitutions"));
        }
        Fop.Renderers renderers = factory.createFopRenderers();
        fopConfig.setRenderers(renderers);
        Fop.Renderers.Renderer renderer = factory.createFopRenderersRenderer();
        renderers.setRenderer(renderer);
        renderer.setMime("application/pdf");
        renderer.setFonts(FopConfigUtil.declareRendererFonts(fontMapper, fontsInUse));
        return fopConfig;
    }

    protected static Fonts declareRendererFonts(Mapper fontMapper, Set<String> fontsInUse) {
        PhysicalFont pf;
        PhysicalFont pf2;
        Fonts rendererFonts = factory.createFonts();
        if (fontsInUse.size() == 0) {
            log.error("No fonts detected in document!");
            return rendererFonts;
        }
        HashMap<String, Fonts.Font> fontEntries = new HashMap<String, Fonts.Font>();
        if (Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.simulate-style", true)) {
            for (String string : fontsInUse) {
                pf2 = null;
                if (string.equals("Webdings") || string.equals("Wingdings") || string.equals("Wingdings 2") || string.equals("Wingdings 3")) {
                    pf = PhysicalFonts.getWDingsFont();
                    pf2 = PhysicalFonts.getWDingsFont2();
                } else {
                    pf = string.equals("Symbol") ? PhysicalFonts.getSymbolFont() : fontMapper.get(string);
                }
                if (pf == null) {
                    log.warn("Document font " + string + " is not mapped to a physical font!");
                    continue;
                }
                FopConfigUtil.createFontEntrySimulateStyles(fontMapper, fontEntries, pf.getName(), pf);
                if (pf2 == null) continue;
                FopConfigUtil.createFontEntrySimulateStyles(fontMapper, fontEntries, pf2.getName(), pf2);
            }
        } else {
            for (String string : fontsInUse) {
                pf2 = null;
                if (string.equals("Webdings") || string.equals("Wingdings") || string.equals("Wingdings 2") || string.equals("Wingdings 3")) {
                    pf = PhysicalFonts.getWDingsFont();
                    pf2 = PhysicalFonts.getWDingsFont2();
                } else {
                    pf = string.equals("Symbol") ? PhysicalFonts.getSymbolFont() : fontMapper.get(string);
                }
                if (pf == null) {
                    log.warn("Document font " + string + " is not mapped to a physical font!");
                    continue;
                }
                FopConfigUtil.createFontEntry(fontMapper, fontEntries, pf.getName(), pf);
                if (pf2 == null) continue;
                FopConfigUtil.createFontEntry(fontMapper, fontEntries, pf2.getName(), pf2);
            }
        }
        if (fontEntries.isEmpty()) {
            log.warn("No fonts configured!");
        } else {
            for (Map.Entry entry : fontEntries.entrySet()) {
                rendererFonts.getFont().add((Fonts.Font)entry.getValue());
            }
        }
        return rendererFonts;
    }

    private static void createFontEntrySimulateStyles(Mapper fontMapper, Map<String, Fonts.Font> fontEntries, String fontName, PhysicalFont pf) {
        Fonts.Font rendererFont = factory.createFontsFont();
        fontEntries.put(pf.getEmbeddedURI().toString(), rendererFont);
        rendererFont.setSimulateStyle(false);
        if (pf.getEmbedFontInfo().getSubFontName() != null) {
            rendererFont.setSubFont(pf.getEmbedFontInfo().getSubFontName());
        }
        if (fontMapper.getBoldForm(fontName, pf) == null || fontMapper.getItalicForm(fontName, pf) == null) {
            Fonts.Font variant;
            rendererFont.setSimulateStyle(true);
            rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
            rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontName, "normal", "normal"));
            PhysicalFont pfVariation = fontMapper.getItalicForm(fontName, pf);
            if (pfVariation == null) {
                rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontName, "italic", "normal"));
                if (log.isDebugEnabled()) {
                    log.debug(fontName + " - no italic form");
                }
            } else {
                variant = FopConfigUtil.createVariant(pf, pfVariation, "italic", "italic", "normal");
                fontEntries.put(variant.getEmbedUrl(), variant);
                if (log.isDebugEnabled()) {
                    log.debug(fontName + " - added italic form");
                }
            }
            if ((pfVariation = fontMapper.getBoldForm(fontName, pf)) == null) {
                rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontName, "normal", "bold"));
                if (log.isDebugEnabled()) {
                    log.debug(fontName + " - no bold form");
                }
            } else {
                variant = FopConfigUtil.createVariant(pf, pfVariation, "bold", "normal", "bold");
                fontEntries.put(variant.getEmbedUrl(), variant);
                if (log.isDebugEnabled()) {
                    log.debug(fontName + " - added bold form");
                }
            }
            rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), "italic", "bold"));
        } else {
            rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
            FontTriplet fontTriplet = pf.getEmbedFontInfo().getFontTriplets().get(0);
            rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight())));
            FopConfigUtil.addVariations(fontMapper, fontEntries, fontName, pf, rendererFont.getSubFont());
        }
    }

    private static void createFontEntry(Mapper fontMapper, Map<String, Fonts.Font> fontEntries, String fontName, PhysicalFont pf) {
        Fonts.Font rendererFont = factory.createFontsFont();
        fontEntries.put(pf.getEmbeddedURI().toString(), rendererFont);
        rendererFont.setSimulateStyle(false);
        if (pf.getEmbedFontInfo().getSubFontName() != null) {
            rendererFont.setSubFont(pf.getEmbedFontInfo().getSubFontName());
        }
        rendererFont.setEmbedUrl(pf.getEmbeddedURI().toString());
        FontTriplet fontTriplet = pf.getEmbedFontInfo().getFontTriplets().get(0);
        rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight())));
        FopConfigUtil.addVariations(fontMapper, fontEntries, fontName, pf, pf.getEmbedFontInfo().getSubFontName());
    }

    private static Fonts.Font.FontTriplet createFontTriplet(String name, String style, String weight) {
        Fonts.Font.FontTriplet triplet = factory.createFontsFontFontTriplet();
        triplet.setName(name);
        triplet.setStyle(style);
        triplet.setWeight(weight);
        return triplet;
    }

    private static void addVariations(Mapper fontMapper, Map<String, Fonts.Font> fontEntries, String fontName, PhysicalFont pf, String subFontAtt) {
        Fonts.Font variant;
        PhysicalFont pfVariation = fontMapper.getBoldForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no bold form");
        } else {
            variant = FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "normal", "bold");
            fontEntries.put(variant.getEmbedUrl(), variant);
        }
        pfVariation = fontMapper.getBoldItalicForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no bold italic form");
        } else {
            variant = FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "italic", "bold");
            fontEntries.put(variant.getEmbedUrl(), variant);
        }
        pfVariation = fontMapper.getItalicForm(fontName, pf);
        if (pfVariation == null) {
            log.debug(fontName + " no italic form");
        } else {
            variant = FopConfigUtil.createVariant(pf, pfVariation, subFontAtt, "italic", "normal");
            fontEntries.put(variant.getEmbedUrl(), variant);
        }
    }

    private static Fonts.Font createVariant(PhysicalFont pf, PhysicalFont pfVariation, String subFontAtt, String style, String weight) {
        Fonts.Font rendererFont = factory.createFontsFont();
        rendererFont.setSimulateStyle(false);
        rendererFont.setEmbedUrl(pfVariation.getEmbeddedURI().toString());
        rendererFont.setSubFont(subFontAtt);
        rendererFont.getFontTriplet().add(FopConfigUtil.createFontTriplet(pf.getName(), style, weight));
        return rendererFont;
    }

    protected static void addFontTriplet(StringBuilder result, String familyName, String style, String weight) {
        result.append("<font-triplet name=\"");
        result.append(familyName);
        result.append('\"');
        result.append(" style=\"");
        result.append(style);
        result.append('\"');
        result.append(" weight=\"");
        result.append(weight);
        result.append("\"/>");
    }

    protected static String weightToCSS2FontWeight(int i) {
        return i >= 700 ? "bold" : "normal";
    }

    static {
        factory = new ObjectFactory();
        String substitutionsPath = Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.substitutions");
        if (substitutionsPath != null) {
            InputStream is = null;
            try {
                is = ResourceUtils.getResource(substitutionsPath);
                Unmarshaller u = Context.getFopConfigContext().createUnmarshaller();
                Object o = u.unmarshal(is);
                substitutions = (Substitutions)o;
            }
            catch (IOException e) {
                log.error("Problems with class path resource " + substitutionsPath);
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

