/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.render.java2d;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.complexscripts.fonts.Positionable;
import org.docx4j.fonts.fop.complexscripts.fonts.Substitutable;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EmbedFontInfo;
import org.docx4j.fonts.fop.fonts.FontType;
import org.docx4j.fonts.fop.fonts.FontUris;
import org.docx4j.fonts.fop.fonts.LazyFont;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.fonts.fop.render.java2d.FontMetricsMapper;

public class CustomFontMetricsMapper
extends Typeface
implements FontMetricsMapper,
Substitutable,
Positionable {
    private Typeface typeface;
    private FontUris fontUris;
    private EmbedFontInfo configFontInfo;
    private InternalResourceResolver resourceResolver;
    private Font font;
    private float size = 1.0f;
    private static final int TYPE1_FONT = 1;

    public CustomFontMetricsMapper(CustomFont fontMetrics) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontMetrics.getInputStream());
    }

    public CustomFontMetricsMapper(LazyFont fontMetrics, InputStream fontSource) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontSource);
    }

    public CustomFontMetricsMapper(FontUris fontUris, EmbedFontInfo configFontInfo, InternalResourceResolver resourceResolver) {
        this.fontUris = fontUris;
        this.configFontInfo = configFontInfo;
        this.resourceResolver = resourceResolver;
    }

    private void initialize(InputStream inStream) throws FontFormatException, IOException {
        int type = 0;
        if (FontType.TYPE1.equals(this.typeface.getFontType())) {
            type = 1;
        }
        this.font = Font.createFont(type, inStream);
        inStream.close();
    }

    @Override
    public final String getEncodingName() {
        return null;
    }

    @Override
    public final boolean hasChar(char c) {
        return this.font.canDisplay(c);
    }

    @Override
    public final char mapChar(char c) {
        return this.typeface.mapChar(c);
    }

    @Override
    public final Font getFont(int size) {
        if (this.size == (float)size) {
            return this.font;
        }
        this.size = (float)size / 1000.0f;
        this.font = this.font.deriveFont(this.size);
        return this.font;
    }

    @Override
    public final int getAscender(int size) {
        return this.typeface.getAscender(size);
    }

    @Override
    public final int getCapHeight(int size) {
        return this.typeface.getCapHeight(size);
    }

    @Override
    public final int getDescender(int size) {
        return this.typeface.getDescender(size);
    }

    @Override
    public final String getEmbedFontName() {
        return this.typeface.getEmbedFontName();
    }

    @Override
    public final Set<String> getFamilyNames() {
        return this.typeface.getFamilyNames();
    }

    @Override
    public final String getFontName() {
        return this.typeface.getFontName();
    }

    @Override
    public final URI getFontURI() {
        return this.typeface.getFontURI();
    }

    @Override
    public final FontType getFontType() {
        return this.typeface.getFontType();
    }

    @Override
    public final String getFullName() {
        return this.typeface.getFullName();
    }

    public final Map getKerningInfo() {
        return this.typeface.getKerningInfo();
    }

    @Override
    public final int getWidth(int i, int size) {
        return this.typeface.getWidth(i, size);
    }

    @Override
    public final int[] getWidths() {
        return this.typeface.getWidths();
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        return this.typeface.getBoundingBox(glyphIndex, size);
    }

    @Override
    public final int getXHeight(int size) {
        return this.typeface.getXHeight(size);
    }

    @Override
    public int getUnderlinePosition(int size) {
        return this.typeface.getUnderlinePosition(size);
    }

    @Override
    public int getUnderlineThickness(int size) {
        return this.typeface.getUnderlineThickness(size);
    }

    @Override
    public int getStrikeoutPosition(int size) {
        return this.typeface.getStrikeoutPosition(size);
    }

    @Override
    public int getStrikeoutThickness(int size) {
        return this.typeface.getStrikeoutThickness(size);
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.typeface.hasKerningInfo();
    }

    @Override
    public boolean isMultiByte() {
        return this.typeface.isMultiByte();
    }

    @Override
    public boolean performsPositioning() {
        if (this.typeface instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (this.typeface instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performPositioning(cs, script, language, fontSize);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        if (this.typeface instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performPositioning(cs, script, language);
        }
        return null;
    }

    @Override
    public boolean performsSubstitution() {
        if (this.typeface instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language, List associations, boolean retainControls) {
        if (this.typeface instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).performSubstitution(cs, script, language, associations, retainControls);
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language, List associations) {
        if (this.typeface instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).reorderCombiningMarks(cs, gpa, script, language, associations);
        }
        return cs;
    }

    public Typeface getRealFont() {
        return this.typeface;
    }
}

