/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.IOException;
import java.net.URI;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EmbeddingMode;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontUris;
import org.docx4j.fonts.fop.fonts.truetype.OFFontLoader;
import org.docx4j.fonts.fop.fonts.type1.Type1FontLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FontLoader {
    protected static final Logger log = LoggerFactory.getLogger(FontLoader.class);
    protected final URI fontFileURI;
    protected final InternalResourceResolver resourceResolver;
    protected CustomFont returnFont;
    protected boolean loaded;
    protected boolean embedded;
    protected boolean useKerning;
    protected boolean useAdvanced;

    public FontLoader(URI fontFileURI, boolean embedded, boolean useKerning, boolean useAdvanced, InternalResourceResolver resourceResolver) {
        this.fontFileURI = fontFileURI;
        this.embedded = embedded;
        this.useKerning = useKerning;
        this.useAdvanced = useAdvanced;
        this.resourceResolver = resourceResolver;
    }

    private static boolean isType1(FontUris fontUris) {
        return fontUris.getEmbed().toASCIIString().toLowerCase().endsWith(".pfb") || fontUris.getAfm() != null || fontUris.getPfm() != null;
    }

    public static CustomFont loadFont(FontUris fontUris, String subFontName, boolean embedded, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean useKerning, boolean useAdvanced, InternalResourceResolver resourceResolver, boolean simulateStyle, boolean embedAsType1, boolean useSVG) throws IOException {
        FontLoader loader;
        boolean type1 = FontLoader.isType1(fontUris);
        if (type1) {
            if (encodingMode == EncodingMode.CID) {
                throw new IllegalArgumentException("CID encoding mode not supported for Type 1 fonts");
            }
            loader = new Type1FontLoader(fontUris, embedded, embeddingMode, useKerning, resourceResolver);
        } else {
            loader = new OFFontLoader(fontUris.getEmbed(), subFontName, embedded, embeddingMode, encodingMode, useKerning, useAdvanced, resourceResolver, simulateStyle, embedAsType1, useSVG);
        }
        return loader.getFont();
    }

    protected abstract void read() throws IOException;

    public CustomFont getFont() throws IOException {
        if (!this.loaded) {
            this.read();
        }
        return this.returnFont;
    }
}

