/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XsltCommonFunctions {
    private static Logger log = LoggerFactory.getLogger(XsltCommonFunctions.class);

    private XsltCommonFunctions() {
    }

    public static DocumentFragment fontSelector(AbstractWmlConversionContext conversionContext, NodeIterator pPrNodeIt, NodeIterator rPrNodeIt, NodeIterator textNodeIt) {
        Object jaxb;
        Unmarshaller u;
        PPr pPr = null;
        RPr rPr = null;
        Text text = null;
        Node n = pPrNodeIt.nextNode();
        if (n != null) {
            try {
                u = Context.jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                jaxb = u.unmarshal(n);
                pPr = (PPr)jaxb;
            }
            catch (ClassCastException e) {
                log.error("Couldn't cast  to RPr!");
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((n = rPrNodeIt.nextNode()) != null) {
            try {
                u = Context.jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                jaxb = u.unmarshal(n);
                if (jaxb instanceof RPr) {
                    rPr = (RPr)jaxb;
                } else if (jaxb instanceof ParaRPr) {
                    rPr = conversionContext.getPropertyResolver().getEffectiveRPr(null, pPr);
                    StyleUtil.apply((ParaRPr)jaxb, rPr);
                }
            }
            catch (ClassCastException e) {
                log.error("Couldn't cast  to RPr!");
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((n = textNodeIt.nextNode()) != null) {
            try {
                u = Context.jc.createUnmarshaller();
                u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                jaxb = u.unmarshal(n);
                text = (Text)jaxb;
            }
            catch (ClassCastException e) {
                log.error("Couldn't cast  to Text!");
            }
            catch (JAXBException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return (DocumentFragment)conversionContext.getRunFontSelector().fontSelector(pPr, rPr, text);
    }

    public static Node toNode(AbstractWmlConversionContext context, Node node, NodeList childResults) {
        return context.getWriterRegistry().toNode(context, node, childResults);
    }

    public static int getNextFootnoteNumber(AbstractWmlConversionContext context) {
        return context.getNextFootnoteNumber();
    }

    public static Node getFootnote(AbstractWmlConversionContext context, String id) {
        WordprocessingMLPackage wmlPackage = context.getWmlPackage();
        CTFootnotes footnotes = (CTFootnotes)wmlPackage.getMainDocumentPart().getFootnotesPart().getJaxbElement();
        int pos = Integer.parseInt(id);
        CTFtnEdn ftn = (CTFtnEdn)footnotes.getFootnote().get(pos);
        Document d = XmlUtils.marshaltoW3CDomDocument(ftn, Context.jc, "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "footnote", CTFtnEdn.class);
        if (log.isDebugEnabled()) {
            log.debug("Footnote " + id + ": " + XmlUtils.w3CDomNodeToString(d));
        }
        return d;
    }

    public static int getNextEndnoteNumber(AbstractWmlConversionContext context) {
        return context.getNextEndnoteNumber();
    }

    public static void setCurrentPart(AbstractWmlConversionContext context, Part currentPart) {
        context.setCurrentPart(currentPart);
    }

    public static Part getCurrentPart(AbstractWmlConversionContext context) {
        return context.getCurrentPart();
    }

    public static void setCurrentPartMainDocument(AbstractWmlConversionContext context) {
        context.setCurrentPartMainDocument();
    }

    public static void setCurrentPartDefaultHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        context.setCurrentPart(currentSection.getHeaderFooterPolicy().getDefaultHeader());
    }

    public static void setCurrentPartDefaultFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        context.setCurrentPart(currentSection.getHeaderFooterPolicy().getDefaultFooter());
    }

    public static void moveNextSection(AbstractWmlConversionContext context) {
        context.getSections().next();
    }

    public static boolean hasDefaultHeaderOrFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getDefaultHeader() != null || currentSection.getHeaderFooterPolicy().getDefaultFooter() != null;
    }

    public static boolean hasFirstHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getFirstHeader() != null;
    }

    public static boolean hasEvenHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getEvenHeader() != null;
    }

    public static boolean hasDefaultHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getDefaultHeader() != null;
    }

    public static boolean hasFirstFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getFirstFooter() != null;
    }

    public static boolean hasEvenFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getEvenFooter() != null;
    }

    public static boolean hasDefaultFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        return currentSection.getHeaderFooterPolicy().getDefaultFooter() != null;
    }

    public static Node getFirstHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Hdr hdr = (Hdr)currentSection.getHeaderFooterPolicy().getFirstHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getFirstFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Ftr ftr = (Ftr)currentSection.getHeaderFooterPolicy().getFirstFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static Node getEvenHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Hdr hdr = (Hdr)currentSection.getHeaderFooterPolicy().getEvenHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getEvenFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Ftr ftr = (Ftr)currentSection.getHeaderFooterPolicy().getEvenFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static Node getDefaultHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Hdr hdr = (Hdr)currentSection.getHeaderFooterPolicy().getDefaultHeader().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(hdr);
    }

    public static Node getDefaultFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        Ftr ftr = (Ftr)currentSection.getHeaderFooterPolicy().getDefaultFooter().getJaxbElement();
        return XmlUtils.marshaltoW3CDomDocument(ftr);
    }

    public static void inFirstHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getFirstHeader());
    }

    public static void inEvenHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getEvenHeader());
    }

    public static void inDefaultHeader(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getDefaultHeader());
    }

    public static void inFirstFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getFirstFooter());
    }

    public static void inEvenFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getEvenFooter());
    }

    public static void inDefaultFooter(AbstractWmlConversionContext context) {
        ConversionSectionWrapper currentSection = context.getSections().getCurrentSection();
        XsltCommonFunctions.setCurrentPart(context, currentSection.getHeaderFooterPolicy().getDefaultFooter());
    }

    public static boolean hasEndnotesPart(AbstractWmlConversionContext context) {
        return context.getWmlPackage().getMainDocumentPart().hasEndnotesPart();
    }

    public static Node getEndnotes(AbstractWmlConversionContext context) {
        return XmlUtils.marshaltoW3CDomDocument(context.getWmlPackage().getMainDocumentPart().getEndNotesPart().getJaxbElement());
    }

    public static boolean hasFootnotesPart(AbstractWmlConversionContext context) {
        return context.getWmlPackage().getMainDocumentPart().hasFootnotesPart();
    }

    public static Node getFootnotes(AbstractWmlConversionContext context) {
        return XmlUtils.marshaltoW3CDomDocument(context.getWmlPackage().getMainDocumentPart().getFootnotesPart().getJaxbElement());
    }

    public static void updateComplexFieldDefinition(AbstractWmlConversionContext context, NodeIterator fldCharNodeIt) {
        FldChar field = null;
        Node node = fldCharNodeIt.nextNode();
        try {
            field = (FldChar)XmlUtils.unmarshal(node, Context.jc, FldChar.class);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        STFldCharType fieldCharType = field.getFldCharType();
        if (fieldCharType == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring unrecognised: " + XmlUtils.w3CDomNodeToString(node));
            }
        } else {
            context.updateComplexFieldDefinition(fieldCharType);
        }
    }

    public static boolean isInComplexFieldDefinition(AbstractWmlConversionContext context) {
        return context.isInComplexFieldDefinition();
    }

    public static DocumentFragment notImplemented(AbstractConversionContext context, NodeIterator nodes, String message) {
        return context.getMessageWriter().notImplemented(context, nodes, message);
    }

    public static DocumentFragment message(AbstractConversionContext context, String message) {
        return context.getMessageWriter().message(context, message);
    }

    public static boolean isLoggingEnabled(AbstractConversionContext context) {
        return context.getLog().isDebugEnabled();
    }

    public static void logDebug(AbstractConversionContext context, String message) {
        context.getLog().debug(message);
    }

    public static void logDebug(AbstractConversionContext context, NodeIterator ni, String message) {
        Node n;
        context.getLog().debug(message);
        while ((n = ni.nextNode()) != null) {
            context.getLog().debug(XmlUtils.w3CDomNodeToString(n));
        }
    }

    public static void logInfo(AbstractConversionContext context, String message) {
        context.getLog().info(message);
    }

    public static void logWarn(AbstractConversionContext context, String message) {
        context.getLog().warn(message);
    }
}

