/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.com.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import org.docx4j.com.google.common.annotations.GwtCompatible;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    static void checkNoConflict(boolean safe, String conflictDescription, Map.Entry<?, ?> entry1, Map.Entry<?, ?> entry2) {
        if (!safe) {
            throw ImmutableMap.conflictException(conflictDescription, entry1, entry2);
        }
    }

    static IllegalArgumentException conflictException(String conflictDescription, Object entry1, Object entry2) {
        return new IllegalArgumentException("Multiple entries with same " + conflictDescription + ": " + entry1 + " and " + entry2);
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap kvMap;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap) && !(kvMap = (ImmutableMap)map).isPartialView()) {
            return kvMap;
        }
        System.out.println("PANIC!");
        return null;
    }

    abstract boolean isPartialView();
}

