/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.wml;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SdtContent;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayListWml<E>
extends ArrayList<E> {
    private static Logger log = LoggerFactory.getLogger(ArrayListWml.class);
    private Object parent = null;

    public ArrayListWml(Object p) {
        this.parent = p;
    }

    private ArrayListWml() {
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return super.indexOf(o);
        }
        for (int i = 0; i < this.size(); ++i) {
            if (o.equals(this.get(i))) {
                return i;
            }
            if (!(this.get(i) instanceof JAXBElement) || !o.equals(((JAXBElement)this.get(i)).getValue())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return super.lastIndexOf(o);
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (o.equals(this.get(i))) {
                return i;
            }
            if (!(this.get(i) instanceof JAXBElement) || !o.equals(((JAXBElement)this.get(i)).getValue())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E set(int index, E e) {
        this.checkParent(e);
        if (e instanceof JAXBElement) {
            this.setParent(((JAXBElement)e).getValue());
        } else {
            this.setParent(e);
        }
        return super.set(index, e);
    }

    @Override
    public boolean add(E e) {
        this.checkParent(e);
        if (e instanceof JAXBElement) {
            this.setParent(((JAXBElement)e).getValue());
        } else {
            this.setParent(e);
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E e) {
        this.checkParent(e);
        if (e instanceof JAXBElement) {
            this.setParent(((JAXBElement)e).getValue());
        } else {
            this.setParent(e);
        }
        super.add(index, e);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            super.remove(o);
        } else {
            for (int i = 0; i < this.size(); ++i) {
                if (o.equals(this.get(i))) {
                    this.remove(i);
                    return true;
                }
                if (!(this.get(i) instanceof JAXBElement) || !o.equals(((JAXBElement)this.get(i)).getValue())) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.checkParent(o);
            if (o instanceof JAXBElement) {
                this.setParent(((JAXBElement)o).getValue());
                continue;
            }
            this.setParent(o);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E o : c) {
            this.checkParent(o);
            if (o instanceof JAXBElement) {
                this.setParent(((JAXBElement)o).getValue());
                continue;
            }
            this.setParent(o);
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        log.info("This method won't remove an object if it is wrapped in a JAXBElement");
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        log.info("This method won't retain an object if it is wrapped in a JAXBElement");
        return super.retainAll(c);
    }

    private void checkParent(E e) {
        if (this.parent == null) {
            log.warn("null parent. how?");
            if (log.isDebugEnabled()) {
                log.debug("Null parent", new Throwable());
            }
        } else {
            if (this.parent instanceof P) {
                if (e instanceof Tbl) {
                    throw new RuntimeException("You can't add a table inside a paragraph; it should be a sibling");
                }
                if (e instanceof P) {
                    throw new RuntimeException("You can't nest a paragraph inside a paragraph.");
                }
                if (e instanceof Text) {
                    throw new RuntimeException("You can't add Text directly to a paragraph; add it to a run (R) and add that.");
                }
            }
            if (this.parent instanceof R) {
                if (e instanceof R) {
                    throw new RuntimeException("You can't nest a run inside a run");
                }
                if (e instanceof P) {
                    throw new RuntimeException("You can't nest a paragraph inside a run.");
                }
                if (e instanceof Tbl) {
                    throw new RuntimeException("You can't add a table inside a run.");
                }
            }
            if (this.parent instanceof SdtContent && e instanceof SdtContent) {
                throw new RuntimeException("You can't nest a bare SdtContent directly inside SdtContent");
            }
        }
    }

    private void setParent(Object o) {
        if (this.parent != null && o instanceof Child) {
            ((Child)o).setParent(this.parent);
        }
    }

    public Object getParent() {
        return this.parent;
    }
}

