/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ArrayRecord;

public class ResultSetRecord
extends ArrayRecord {
    protected transient ResultSet resultSet;
    protected transient ResultSetMetaData metaData;
    protected transient DatabaseAccessor accessor;
    protected transient DatabasePlatform platform;
    protected transient boolean optimizeData;
    protected transient AbstractSession session;

    protected ResultSetRecord() {
    }

    public ResultSetRecord(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, DatabaseAccessor accessor, AbstractSession session, DatabasePlatform platform, boolean optimizeData) {
        super(fields, fieldsArray, new Object[fieldsArray.length]);
        this.resultSet = resultSet;
        this.metaData = metaData;
        this.accessor = accessor;
        this.platform = platform;
        this.optimizeData = optimizeData;
        this.session = session;
    }

    public void loadAllValuesFromResultSet() {
        int size = this.valuesArray.length;
        for (int index = 0; index < size; ++index) {
            DatabaseField field;
            if (this.valuesArray[index] != null || (field = this.fieldsArray[index]) == null) continue;
            this.valuesArray[index] = this.accessor.getObject(this.resultSet, field, this.metaData, index + 1, this.platform, this.optimizeData, this.session);
        }
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    public void removeNonIndirectionValues() {
        if (this.fieldsArray != null) {
            int size = this.valuesArray.length;
            for (int index = 0; index < size; ++index) {
                DatabaseField field = this.fieldsArray[index];
                if (field == null || field.keepInRow) continue;
                this.valuesArray[index] = null;
            }
        }
    }

    public void removAllValue() {
        if (this.valuesArray != null) {
            int size = this.valuesArray.length;
            for (int index = 0; index < size; ++index) {
                this.valuesArray[index] = null;
            }
        }
    }

    public boolean hasResultSet() {
        return this.resultSet != null;
    }

    public void removeResultSet() {
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    @Override
    public void clear() {
        this.removeResultSet();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.clear();
    }

    @Override
    protected void checkValues() {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        super.checkValues();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        return super.containsValue(value);
    }

    @Override
    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.index;
            if (index < 0 || index >= this.size) {
                index = 0;
            }
            if ((field = this.fieldsArray[index]) != key && !field.equals(key)) {
                index = -1;
                for (int fieldIndex = 0; fieldIndex < this.size; ++fieldIndex) {
                    field = this.fieldsArray[fieldIndex];
                    if (field != key && !field.equals(key)) continue;
                    if (key.index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    index = fieldIndex;
                    break;
                }
                if (index < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value = this.valuesArray[index];
                if (value == null) {
                    this.valuesArray[index] = value = this.accessor.getObject(this.resultSet, field, this.metaData, index + 1, this.platform, this.optimizeData, this.session);
                } else {
                    this.loadAllValuesFromResultSet();
                }
                return value;
            }
            return this.valuesArray[index];
        }
        return super.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field;
            int index = key.index;
            if (index < 0 || index >= this.size) {
                index = 0;
            }
            if ((field = this.fieldsArray[index]) != key && !field.equals(key)) {
                index = -1;
                for (int fieldIndex = 0; fieldIndex < this.size; ++fieldIndex) {
                    field = this.fieldsArray[fieldIndex];
                    if (field != key && !field.equals(key)) continue;
                    if (key.index == -1) {
                        key.setIndex(fieldIndex);
                    }
                    index = fieldIndex;
                    break;
                }
                if (index < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value = this.valuesArray[index];
                if (value == null) {
                    this.valuesArray[index] = value = this.accessor.getObject(this.resultSet, field, this.metaData, index + 1, this.platform, this.optimizeData, this.session);
                } else {
                    this.loadAllValuesFromResultSet();
                }
                return value;
            }
            return this.valuesArray[index];
        }
        return super.get(key);
    }

    @Override
    protected String toStringAditional() {
        return this.resultSet != null ? " hasResultSet" : "";
    }

    @Override
    public void setSopObject(Object sopObject) {
        super.setSopObject(sopObject);
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
    }
}

