/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.throwables.ConverterException;
import com.documents4j.ws.ConverterNetworkProtocol;
import com.google.common.base.MoreObjects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;

class WebserviceRequestFutureWrapper
implements Future<Boolean> {
    private final Future<Response> futureResponse;

    public WebserviceRequestFutureWrapper(Future<Response> futureResponse) {
        this.futureResponse = futureResponse;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futureResponse.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.futureResponse.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.futureResponse.isDone();
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        return this.handle(this.futureResponse.get());
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.handle(this.futureResponse.get(timeout, unit));
    }

    private boolean handle(Response response) throws ExecutionException {
        try {
            return ConverterNetworkProtocol.Status.from((int)response.getStatus()).resolve();
        }
        catch (ConverterException e) {
            throw new ExecutionException("The conversion resulted in an error", e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(WebserviceRequestFutureWrapper.class).add("futureResponse", this.futureResponse).toString();
    }
}

