/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.DocumentType;
import com.documents4j.api.IConversionJob;
import com.documents4j.api.IConversionJobWithPriorityUnspecified;
import com.documents4j.api.IConversionJobWithSourceSpecified;
import com.documents4j.api.IConversionJobWithSourceUnspecified;
import com.documents4j.api.IConversionJobWithTargetUnspecified;
import com.documents4j.api.IConverter;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.job.AbstractConverterBuilder;
import com.documents4j.job.ConversionJobAdapter;
import com.documents4j.job.ConversionJobWithSourceSpecifiedAdapter;
import com.documents4j.job.ConverterAdapter;
import com.documents4j.job.RemoteFutureWrappingPriorityFuture;
import com.documents4j.ws.ConverterServerInformation;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.EncodingFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.message.GZipEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConverter
extends ConverterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteConverter.class);
    private final Client client;
    private final URI baseUri;
    private final ExecutorService executorService;
    private final long requestTimeout;

    protected RemoteConverter(URI baseUri, File baseFolder, long requestTimeout, int corePoolSize, int maximumPoolSize, long keepAliveTime, SSLContext sslContext, UsernamePasswordCredentials usernamePasswordCredentials) {
        super(baseFolder);
        this.client = RemoteConverter.makeClient(requestTimeout, maximumPoolSize, sslContext, usernamePasswordCredentials);
        this.baseUri = baseUri;
        this.executorService = RemoteConverter.makeExecutorService((int)corePoolSize, (int)maximumPoolSize, (long)keepAliveTime);
        this.requestTimeout = requestTimeout;
        LOGGER.info("The documents4j remote converter has started successfully (URI: {})", (Object)baseUri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IConverter make(URI baseUri) {
        return RemoteConverter.builder().baseUri(baseUri).build();
    }

    public static IConverter make(String baseUri) {
        return RemoteConverter.builder().baseUri(baseUri).build();
    }

    private static Client makeClient(long requestTimeout, int maxConnections, SSLContext sslContext, UsernamePasswordCredentials usernamePasswordCredentials) {
        ClientConfig clientConfig = new ClientConfig();
        int castRequestTimeout = Ints.checkedCast((long)requestTimeout);
        clientConfig.register((Object)RemoteConverter.makeGZipFeature());
        clientConfig.property("jersey.config.client.async.threadPoolSize", (Object)maxConnections);
        clientConfig.property("jersey.config.client.connectTimeout", (Object)castRequestTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)castRequestTimeout);
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)RemoteConverter.makeConnectionManager(maxConnections));
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        if (usernamePasswordCredentials != null && usernamePasswordCredentials.getUserName() != null && !usernamePasswordCredentials.getUserName().isEmpty()) {
            clientConfig.register((Object)HttpAuthenticationFeature.basicBuilder().credentials(usernamePasswordCredentials.getUserName(), usernamePasswordCredentials.getPassword()).build());
        }
        if (sslContext != null) {
            return ClientBuilder.newBuilder().sslContext(sslContext).withConfig((Configuration)clientConfig).build();
        }
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    private static Feature makeGZipFeature() {
        return new EncodingFeature("gzip", new Class[]{GZipEncoder.class});
    }

    private static HttpClientConnectionManager makeConnectionManager(int maxConnections) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnections);
        return connectionManager;
    }

    private WebTarget makeTarget() {
        return this.client.target(this.baseUri).path("/");
    }

    public IConversionJobWithSourceUnspecified convert(IInputStreamSource source) {
        return new RemoteConversionJobWithSourceUnspecified(source);
    }

    public Map<DocumentType, Set<DocumentType>> getSupportedConversions() {
        return this.fetchConverterServerInformation().getSupportedConversions();
    }

    public boolean isOperational() {
        try {
            return !this.executorService.isShutdown() && this.fetchConverterServerInformation().isOperational();
        }
        catch (Exception e) {
            LOGGER.warn("Could not connect to conversion server @ {}", (Object)this.baseUri, (Object)e);
            return false;
        }
    }

    private ConverterServerInformation fetchConverterServerInformation() {
        return this.logConverterServerInformation((ConverterServerInformation)this.makeTarget().request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ConverterServerInformation.class));
    }

    private ConverterServerInformation logConverterServerInformation(ConverterServerInformation converterServerInformation) {
        LOGGER.info("Currently operational @ conversion server: {}", (Object)converterServerInformation.isOperational());
        LOGGER.info("Request timeout @ conversion server: {}", (Object)converterServerInformation.getTimeout());
        LOGGER.info("Protocol version @ conversion server: {}", (Object)converterServerInformation.getProtocolVersion());
        if (converterServerInformation.getProtocolVersion() != 1) {
            LOGGER.warn("Server protocol version ({}) does not match client protocol version ({})", (Object)converterServerInformation.getProtocolVersion(), (Object)1);
        }
        return converterServerInformation;
    }

    public void shutDown() {
        try {
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(this.requestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.info("The documents4j remote converter could not await termination", (Throwable)e);
            }
            finally {
                this.client.close();
            }
        }
        finally {
            super.shutDown();
        }
        LOGGER.info("The documents4j remote converter has shut down successfully (URI: {})", (Object)this.baseUri);
    }

    public void kill() {
        try {
            try {
                this.executorService.shutdownNow();
            }
            finally {
                this.client.close();
            }
        }
        finally {
            super.kill();
        }
        LOGGER.info("The documents4j remote converter has shut down successfully (URI: {})", (Object)this.baseUri);
    }

    private class RemoteConversionJob
    extends ConversionJobAdapter
    implements IConversionJobWithPriorityUnspecified {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;
        private final IInputStreamConsumer callback;
        private final DocumentType targetFormat;
        private final int priority;

        private RemoteConversionJob(IInputStreamSource source, DocumentType sourceFormat, IInputStreamConsumer callback, DocumentType targetFormat, int priority) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.callback = callback;
            this.targetFormat = targetFormat;
            this.priority = priority;
        }

        public Future<Boolean> schedule() {
            RemoteFutureWrappingPriorityFuture job = new RemoteFutureWrappingPriorityFuture(RemoteConverter.this.makeTarget(), this.source, this.sourceFormat, this.callback, this.targetFormat, this.priority);
            RemoteConverter.this.executorService.execute((Runnable)((Object)job));
            return job;
        }

        public IConversionJob prioritizeWith(int priority) {
            return new RemoteConversionJob(this.source, this.sourceFormat, this.callback, this.targetFormat, priority);
        }
    }

    private class RemoteConversionJobWithTargetUnspecified
    implements IConversionJobWithTargetUnspecified {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;
        private final IInputStreamConsumer callback;

        private RemoteConversionJobWithTargetUnspecified(IInputStreamSource source, DocumentType sourceFormat, IInputStreamConsumer callback) {
            this.source = source;
            this.sourceFormat = sourceFormat;
            this.callback = callback;
        }

        public IConversionJobWithPriorityUnspecified as(DocumentType targetFormat) {
            return new RemoteConversionJob(this.source, this.sourceFormat, this.callback, targetFormat, 500);
        }
    }

    private class RemoteConversionJobWithSourceSpecified
    extends ConversionJobWithSourceSpecifiedAdapter {
        private final IInputStreamSource source;
        private final DocumentType sourceFormat;

        private RemoteConversionJobWithSourceSpecified(IInputStreamSource source, DocumentType sourceFormat) {
            this.source = source;
            this.sourceFormat = sourceFormat;
        }

        public IConversionJobWithTargetUnspecified to(IInputStreamConsumer callback) {
            return new RemoteConversionJobWithTargetUnspecified(this.source, this.sourceFormat, callback);
        }

        protected File makeTemporaryFile(String suffix) {
            return RemoteConverter.this.makeTemporaryFile(suffix);
        }
    }

    private class RemoteConversionJobWithSourceUnspecified
    implements IConversionJobWithSourceUnspecified {
        private final IInputStreamSource source;

        private RemoteConversionJobWithSourceUnspecified(IInputStreamSource source) {
            this.source = source;
        }

        public IConversionJobWithSourceSpecified as(DocumentType sourceFormat) {
            return new RemoteConversionJobWithSourceSpecified(this.source, sourceFormat);
        }
    }

    public static final class Builder
    extends AbstractConverterBuilder<Builder> {
        public static final long DEFAULT_REQUEST_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
        private URI baseUri;
        private long requestTimeout = DEFAULT_REQUEST_TIMEOUT;
        private SSLContext sslContext;
        private String userName;
        private String password;

        private Builder() {
        }

        public Builder baseUri(URI baseUri) {
            Preconditions.checkNotNull((Object)baseUri);
            this.baseUri = baseUri;
            return this;
        }

        public Builder baseUri(String baseUri) {
            Preconditions.checkNotNull((Object)baseUri);
            this.baseUri = URI.create(baseUri);
            return this;
        }

        public Builder requestTimeout(long timeout, TimeUnit unit) {
            Builder.assertNumericArgument((long)timeout, (boolean)true, (long)Integer.MAX_VALUE);
            this.requestTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            Preconditions.checkNotNull((Object)sslContext);
            this.sslContext = sslContext;
            return this;
        }

        public Builder basicAuthenticationCredentials(String userName, String password) {
            this.userName = userName;
            this.password = password;
            return this;
        }

        public IConverter build() {
            Preconditions.checkNotNull((Object)this.baseUri, (Object)"The base URI was not set");
            return new RemoteConverter(this.baseUri, this.normalizedBaseFolder(), this.requestTimeout, this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.sslContext, this.userName != null ? new UsernamePasswordCredentials(this.userName, this.password) : null);
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public long getRequestTimeout() {
            return this.requestTimeout;
        }
    }
}

