/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.event.impl.OpenElementEventImpl;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class CloseElementEventImpl
extends DiffXEventBase
implements CloseElementEvent {
    private final OpenElementEvent open;

    public CloseElementEventImpl(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("Element must have a name.");
        }
        this.open = new OpenElementEventImpl(name);
    }

    public CloseElementEventImpl(OpenElementEvent event) throws NullPointerException {
        if (event == null) {
            throw new NullPointerException("A close element must correspond to an open element.");
        }
        this.open = event;
    }

    @Override
    public String getName() {
        return this.open.getName();
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public OpenElementEvent getOpenElement() {
        return this.open;
    }

    @Override
    public boolean match(OpenElementEvent event) {
        if (event == null) {
            return false;
        }
        if (event == this.open) {
            return true;
        }
        return event.getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return 53 + this.open.hashCode();
    }

    @Override
    public boolean equals(DiffXEvent e) {
        if (e.getClass() != this.getClass()) {
            return false;
        }
        CloseElementEventImpl ce = (CloseElementEventImpl)e;
        return ce.getName().equals(this.getName());
    }

    public String toString() {
        return "closeElement: " + this.getName();
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.closeElement();
    }

    @Override
    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append("</").append(this.getName()).append('>');
        return xml;
    }
}

