/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx;

import com.topologi.diffx.DiffXException;
import com.topologi.diffx.algorithm.DiffXAlgorithm;
import com.topologi.diffx.algorithm.DiffXFitWesyma;
import com.topologi.diffx.algorithm.DiffXFitopsy;
import com.topologi.diffx.algorithm.DiffXFitsy;
import com.topologi.diffx.algorithm.DiffXKumarRangan;
import com.topologi.diffx.algorithm.GuanoAlgorithm;
import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.config.WhiteSpaceProcessing;
import com.topologi.diffx.format.BasicXMLFormatter;
import com.topologi.diffx.format.ConvenientXMLFormatter;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.format.SafeXMLFormatter;
import com.topologi.diffx.format.SmartXMLFormatter;
import com.topologi.diffx.format.StrictXMLFormatter;
import com.topologi.diffx.format.XMLDiffXFormatter;
import com.topologi.diffx.load.DOMRecorder;
import com.topologi.diffx.load.Recorder;
import com.topologi.diffx.load.SAXRecorder;
import com.topologi.diffx.load.TextRecorder;
import com.topologi.diffx.sequence.EventSequence;
import com.topologi.diffx.sequence.SequenceSlicer;
import com.topologi.diffx.util.CommandLine;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class Main {
    private Main() {
    }

    public static boolean equivalent(File xml1, File xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(xml1);
        EventSequence seq1 = recorder.process(xml2);
        return seq0.equals(seq1);
    }

    public static boolean equivalent(InputStream xml1, InputStream xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(new InputSource(xml1));
        EventSequence seq1 = recorder.process(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static boolean equivalent(Reader xml1, Reader xml2) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq0 = recorder.process(new InputSource(xml1));
        EventSequence seq1 = recorder.process(new InputSource(xml2));
        return seq0.equals(seq1);
    }

    public static void diff(Node xml1, Node xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        DOMRecorder loader = new DOMRecorder();
        if (config != null) {
            loader.setConfig(config);
        }
        EventSequence seq1 = loader.process(xml1);
        EventSequence seq2 = loader.process(xml2);
        Main.diff(seq1, seq2, out, config);
    }

    public static void diff(NodeList xml1, NodeList xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        DOMRecorder loader = new DOMRecorder();
        if (config != null) {
            loader.setConfig(config);
        }
        EventSequence seq1 = loader.process(xml1);
        EventSequence seq2 = loader.process(xml2);
        Main.diff(seq1, seq2, out, config);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        if (config != null) {
            recorder.setConfig(config);
        }
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, out, config);
    }

    public static void diff(Reader xml1, Reader xml2, Writer out) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, out, new DiffXConfig());
    }

    public static void diff(InputStream xml1, InputStream xml2, OutputStream out) throws DiffXException, IOException {
        SAXRecorder recorder = new SAXRecorder();
        EventSequence seq1 = recorder.process(new InputSource(xml1));
        EventSequence seq2 = recorder.process(new InputSource(xml2));
        Main.diff(seq1, seq2, (Writer)new OutputStreamWriter(out), new DiffXConfig());
    }

    private static void diff(EventSequence seq1, EventSequence seq2, Writer out, DiffXConfig config) throws DiffXException, IOException {
        SafeXMLFormatter formatter = new SafeXMLFormatter(out);
        formatter.declarePrefixMapping(seq1.getPrefixMapping());
        formatter.declarePrefixMapping(seq2.getPrefixMapping());
        if (config != null) {
            formatter.setConfig(config);
        }
        SequenceSlicer slicer = new SequenceSlicer(seq1, seq2);
        slicer.slice();
        slicer.formatStart(formatter);
        GuanoAlgorithm df = new GuanoAlgorithm(seq1, seq2);
        df.process(formatter);
        slicer.formatEnd(formatter);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            Main.usage();
        }
        try {
            OutputStreamWriter out;
            DiffXFormatter formatter;
            boolean profile = CommandLine.hasSwitch("-profile", args);
            boolean slice = !CommandLine.hasSwitch("-noslice", args);
            boolean quiet = CommandLine.hasSwitch("-quiet", args);
            File xml1 = new File(args[args.length - 2]);
            File xml2 = new File(args[args.length - 1]);
            long t0 = System.currentTimeMillis();
            Recorder recorder = Main.getRecorder(args);
            EventSequence seq1 = recorder.process(xml1);
            EventSequence seq2 = recorder.process(xml2);
            long t1 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Loaded files in " + (t1 - t0) + "ms");
            }
            DiffXConfig config = new DiffXConfig();
            config.setGranularity(Main.getTextGranularity(args));
            config.setWhiteSpaceProcessing(Main.getWhiteSpaceProcessing(args));
            if (!quiet) {
                System.err.println("Whitespace processing: " + Main.getTextGranularity(args) + " " + Main.getWhiteSpaceProcessing(args));
            }
            if ((formatter = Main.getFormatter(args, out = new OutputStreamWriter(Main.getOutput(args), "utf-8"))) instanceof XMLDiffXFormatter) {
                ((XMLDiffXFormatter)formatter).declarePrefixMapping(seq1.getPrefixMapping());
                ((XMLDiffXFormatter)formatter).declarePrefixMapping(seq2.getPrefixMapping());
            }
            formatter.setConfig(config);
            SequenceSlicer slicer = new SequenceSlicer(seq1, seq2);
            if (slice) {
                slicer.slice();
                slicer.formatStart(formatter);
            }
            if (!quiet) {
                System.err.println("Matrix: " + seq1.size() + "x" + seq2.size());
            }
            DiffXAlgorithm df = Main.getAlgorithm(args, seq1, seq2);
            df.process(formatter);
            if (slice) {
                slicer.formatEnd(formatter);
            }
            long t2 = System.currentTimeMillis();
            if (profile) {
                System.err.println("Executed algorithm files in " + (t2 - t1) + "ms");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void usage() {
        System.err.println("Compare the SAX events returned by two XML files.");
        System.err.println("usage:");
        System.err.println("  Main [options] xml_file1 xml_file2");
        System.err.println("where:");
        System.err.println("  xml_file1 = Path to the new XML file");
        System.err.println("  xml_file2 = Path to the old XML file");
        System.err.println("options:");
        System.err.println("  -profile    Display profiling info");
        System.err.println("  -noslice    Do not use slicing");
        System.err.println("  -o [output] The output file");
        System.err.println("  -L [loader] Choose a specific loader");
        System.err.println("               sax* | dom | text");
        System.err.println("  -A [algo]   Choose a specific algorithm");
        System.err.println("               fitsy* | guano | fitopsy | kumar | wesyma");
        System.err.println("  -F [format] Choose a specific formatter");
        System.err.println("               smart* | basic | convenient | strict | short");
        System.err.println("  -W [wsp]    Define whitespace processing");
        System.err.println("               preserve* | compare | ignore");
        System.err.println("  -G [granul] Define text diffing granularity");
        System.err.println("               word* | text | character");
        System.err.println(" * indicates option used by default.");
        System.exit(1);
    }

    private static Recorder getRecorder(String[] args) {
        String loaderArg = CommandLine.getParameter("-L", args);
        if (loaderArg == null || "sax".equals(loaderArg)) {
            return new SAXRecorder();
        }
        if ("dom".equals(loaderArg)) {
            return new DOMRecorder();
        }
        if ("text".equals(loaderArg)) {
            return new TextRecorder();
        }
        Main.usage();
        return null;
    }

    private static OutputStream getOutput(String[] args) throws FileNotFoundException {
        String outArg = CommandLine.getParameter("-o", args);
        if (outArg == null) {
            return System.out;
        }
        return new BufferedOutputStream(new FileOutputStream(outArg));
    }

    private static DiffXAlgorithm getAlgorithm(String[] args, EventSequence seq1, EventSequence seq2) {
        String loaderArg = CommandLine.getParameter("-A", args);
        if (loaderArg == null || "fitsy".equals(loaderArg)) {
            return new DiffXFitsy(seq1, seq2);
        }
        if ("guano".equals(loaderArg)) {
            return new GuanoAlgorithm(seq1, seq2);
        }
        if ("fitopsy".equals(loaderArg)) {
            return new DiffXFitopsy(seq1, seq2);
        }
        if ("kumar".equals(loaderArg)) {
            return new DiffXKumarRangan(seq1, seq2);
        }
        if ("wesyma".equals(loaderArg)) {
            return new DiffXFitWesyma(seq1, seq2);
        }
        Main.usage();
        return null;
    }

    private static DiffXFormatter getFormatter(String[] args, Writer out) throws IOException {
        String formatArg = CommandLine.getParameter("-F", args);
        if (formatArg == null || "smart".equals(formatArg)) {
            return new SmartXMLFormatter(out);
        }
        if ("convenient".equals(formatArg)) {
            return new ConvenientXMLFormatter(out);
        }
        if ("basic".equals(formatArg)) {
            return new BasicXMLFormatter(out);
        }
        if ("strict".equals(formatArg)) {
            return new StrictXMLFormatter(out);
        }
        if ("short".equals(formatArg)) {
            return new StrictXMLFormatter(out);
        }
        Main.usage();
        return null;
    }

    private static WhiteSpaceProcessing getWhiteSpaceProcessing(String[] args) throws IOException {
        String formatArg = CommandLine.getParameter("-W", args);
        if (formatArg == null || "preserve".equals(formatArg)) {
            return WhiteSpaceProcessing.PRESERVE;
        }
        if ("compare".equals(formatArg)) {
            return WhiteSpaceProcessing.COMPARE;
        }
        if ("ignore".equals(formatArg)) {
            return WhiteSpaceProcessing.IGNORE;
        }
        Main.usage();
        return null;
    }

    private static TextGranularity getTextGranularity(String[] args) throws IOException {
        String formatArg = CommandLine.getParameter("-G", args);
        if (formatArg == null || "word".equals(formatArg)) {
            return TextGranularity.WORD;
        }
        if ("text".equals(formatArg)) {
            return TextGranularity.TEXT;
        }
        if ("character".equals(formatArg)) {
            return TextGranularity.CHARACTER;
        }
        Main.usage();
        return null;
    }
}

