/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.fontstore;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontFamily;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.fontstore.FontUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public abstract class AbstractFontStore {
    public abstract PdfBoxFontResolver.FontDescription resolveFont(SharedContext var1, String var2, float var3, IdentValue var4, IdentValue var5, IdentValue var6);

    public static class BuiltinFontStore
    extends AbstractFontStore {
        final Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> _fontFamilies = BuiltinFontStore.createInitialFontMap();

        public BuiltinFontStore(PDDocument doc) {
        }

        static Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> createInitialFontMap() {
            HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result = new HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>>();
            BuiltinFontStore.addCourier(result);
            BuiltinFontStore.addTimes(result);
            BuiltinFontStore.addHelvetica(result);
            BuiltinFontStore.addSymbol(result);
            BuiltinFontStore.addZapfDingbats(result);
            return result;
        }

        static void addCourier(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily courier = new FontFamily("Courier");
            courier.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.COURIER_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
            courier.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.COURIER_OBLIQUE), IdentValue.OBLIQUE, 400));
            courier.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.COURIER_BOLD), IdentValue.NORMAL, 700));
            courier.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.COURIER), IdentValue.NORMAL, 400));
            result.put("DialogInput", (FontFamily<PdfBoxFontResolver.FontDescription>)courier);
            result.put("Monospaced", (FontFamily<PdfBoxFontResolver.FontDescription>)courier);
            result.put("Courier", (FontFamily<PdfBoxFontResolver.FontDescription>)courier);
        }

        static void addTimes(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily times = new FontFamily("Times");
            times.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.TIMES_BOLD_ITALIC), IdentValue.ITALIC, 700));
            times.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.TIMES_ITALIC), IdentValue.ITALIC, 400));
            times.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.TIMES_BOLD), IdentValue.NORMAL, 700));
            times.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.TIMES_ROMAN), IdentValue.NORMAL, 400));
            result.put("Serif", (FontFamily<PdfBoxFontResolver.FontDescription>)times);
            result.put("TimesRoman", (FontFamily<PdfBoxFontResolver.FontDescription>)times);
        }

        static void addHelvetica(HashMap<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily helvetica = new FontFamily("Helvetica");
            helvetica.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD_OBLIQUE), IdentValue.OBLIQUE, 700));
            helvetica.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA_OBLIQUE), IdentValue.OBLIQUE, 400));
            helvetica.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD), IdentValue.NORMAL, 700));
            helvetica.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), IdentValue.NORMAL, 400));
            result.put("Dialog", (FontFamily<PdfBoxFontResolver.FontDescription>)helvetica);
            result.put("SansSerif", (FontFamily<PdfBoxFontResolver.FontDescription>)helvetica);
            result.put("Helvetica", (FontFamily<PdfBoxFontResolver.FontDescription>)helvetica);
        }

        static void addSymbol(Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily fontFamily = new FontFamily("Symbol");
            fontFamily.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.SYMBOL), IdentValue.NORMAL, 400));
            result.put("Symbol", (FontFamily<PdfBoxFontResolver.FontDescription>)fontFamily);
        }

        static void addZapfDingbats(Map<String, FontFamily<PdfBoxFontResolver.FontDescription>> result) {
            FontFamily fontFamily = new FontFamily("ZapfDingbats");
            fontFamily.addFontDescription((MinimalFontDescription)new PdfBoxFontResolver.FontDescription((PDFont)new PDType1Font(Standard14Fonts.FontName.ZAPF_DINGBATS), IdentValue.NORMAL, 400));
            result.put("ZapfDingbats", (FontFamily<PdfBoxFontResolver.FontDescription>)fontFamily);
        }

        @Override
        public PdfBoxFontResolver.FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
            String normalizedFontFamily = FontUtil.normalizeFontFamily(fontFamily);
            FontFamily<PdfBoxFontResolver.FontDescription> family = this._fontFamilies.get(normalizedFontFamily);
            if (family != null) {
                return (PdfBoxFontResolver.FontDescription)family.match(FontResolverHelper.convertWeightToInt((IdentValue)weight), style);
            }
            return null;
        }
    }

    public static class EmptyFontStore
    extends AbstractFontStore {
        @Override
        public PdfBoxFontResolver.FontDescription resolveFont(SharedContext ctx, String fontFamily, float size, IdentValue weight, IdentValue style, IdentValue variant) {
            return null;
        }
    }
}

