/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.XmlNameUtil;
import org.docx4j.model.datastorage.XsltProvider;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.SdtPr;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XsltFinisher {
    private static Logger log = LoggerFactory.getLogger(XsltFinisher.class);
    private WordprocessingMLPackage wordMLPackage;
    static XsltProvider xsltProvider;

    private XsltFinisher() {
    }

    public XsltFinisher(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public static void setXsltProvider(XsltProvider xsltProvider) {
        XsltFinisher.xsltProvider = xsltProvider;
    }

    public void apply(JaxbXmlPart part, Map<String, Xpaths.Xpath> xpathsMap, String filename, Map<String, Map<String, Object>> finisherParams) throws Docx4JException {
        Templates template;
        if (xsltProvider == null) {
            log.debug("No XsltProvider, skipping finisher.");
            return;
        }
        try {
            template = xsltProvider.getFinisherXslt(filename);
            if (template == null) {
                log.debug("No XsltFinisher, skipping.");
            }
        }
        catch (TransformerConfigurationException e1) {
            throw new Docx4JException(e1.getMessage(), e1);
        }
        Source source = null;
        Result result = null;
        XMLStreamReader xmlReader = null;
        ByteArrayOutputStream baos = null;
        Document doc = null;
        if (part.isUnmarshalled()) {
            log.debug(part.getPartName().getName() + " already unmarshalled.");
            doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
            source = new DOMSource(doc);
            result = new DOMResult();
        } else {
            log.debug(part.getPartName().getName() + " not yet unmarshalled.");
            try {
                xmlReader = part.getXMLStreamReader(null);
                source = new StAXSource(xmlReader);
                baos = new ByteArrayOutputStream();
                result = new StreamResult(baos);
            }
            catch (Exception e) {
                throw new Docx4JException(e.getMessage(), e);
            }
        }
        HashMap<String, Object> transformParameters = new HashMap<String, Object>();
        transformParameters.put("customXmlDataStorageParts", part.getPackage().getCustomXmlDataStorageParts());
        transformParameters.put("wmlPackage", this.wordMLPackage);
        transformParameters.put("sourcePart", part);
        transformParameters.put("xPathsMap", xpathsMap);
        transformParameters.put("finisherParams", finisherParams);
        XmlUtils.transform(source, template, transformParameters, result);
        if (result instanceof DOMResult) {
            try {
                part.setJaxbElement(this.unmarshal((Document)((DOMResult)result).getNode(), Docx4jProperties.getProperty("docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue", false)));
            }
            catch (UnmarshalException e) {
                if (!Docx4jProperties.getProperty("docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue", false)) {
                    log.error("Configured to fail in the case of content loss; you can set property docx4j.model.datastorage.BindingTraverserXSLT.ValidationEventContinue if you wish to force output to be generated");
                }
                throw new Docx4JException("Problems applying bindings", (Exception)((Object)e));
            }
            catch (Exception e) {
                log.error("Problem: " + XmlUtils.w3CDomNodeToString(((DOMResult)result).getNode()));
                throw new Docx4JException(e.getMessage(), e);
            }
        }
        try {
            xmlReader.close();
            baos.flush();
            if (log.isDebugEnabled()) {
                byte[] bytes = baos.toByteArray();
                log.debug(new String(bytes));
                part.replacePartContent(bytes);
            } else {
                part.replacePartContent(baos.toByteArray());
            }
            baos.close();
        }
        catch (Exception e) {
            throw new Docx4JException(e.getMessage(), e);
        }
    }

    private Object unmarshal(Node n, boolean continu) throws JAXBException {
        Unmarshaller u = Context.jc.createUnmarshaller();
        JaxbValidationEventHandler veh = new JaxbValidationEventHandler();
        veh.setContinue(continu);
        u.setEventHandler((ValidationEventHandler)veh);
        return u.unmarshal(n);
    }

    public static String getTemplateName(String tag) {
        HashMap<String, String> map = QueryString.parseQueryString(tag, true);
        return map.get("od:finish");
    }

    public static String getXPathValue(Map<String, String> pathMap, WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, NodeIterator sdtPrNodeIt) {
        SdtPr sdtPr = null;
        Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        CTDataBinding dataBinding = sdtPr.getDataBinding();
        String storeItemId = dataBinding.getStoreItemID();
        String xpath = dataBinding.getXpath();
        String prefixMappings = dataBinding.getPrefixMappings();
        return XsltFinisher.getXPathValue(pathMap, pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
    }

    public static String getXPathValue(Map<String, String> pathMap, WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        String r = null;
        if (pathMap != null) {
            r = pathMap.get(XsltFinisher.normalisePath(xpath));
        }
        if (r == null) {
            log.debug("cache miss for " + xpath);
            r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
        } else if (log.isDebugEnabled() && r.trim().length() == 0 && (r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings)).trim().length() > 0) {
            log.warn("cache query " + xpath);
        }
        r = r.trim();
        if (xpath.startsWith("local-name")) {
            r = XmlNameUtil.descapeXmlTypeName(r);
        }
        return r;
    }

    private static String normalisePath(String xpIn) {
        return xpIn.replace("][1]", "]");
    }

    public static Object getParam(Map<String, Map<String, Object>> finisherParams, String templateName, String paramName) {
        return finisherParams.get(templateName).get(paramName);
    }
}

