/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.io.File;
import java.util.Set;
import org.docx4j.Docx4jProperties;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityPlusMapper
extends Mapper {
    protected static Logger log = LoggerFactory.getLogger(IdentityPlusMapper.class);

    public IdentityPlusMapper() {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") < 0) {
            log.warn("WARNING! SubstituterWindowsPlatformImpl works best on Windows.  To get good results on other platforms, you'll probably  need to have installed Windows fonts.");
        }
    }

    @Override
    public void populateFontMappings(Set<String> documentFontNames, Fonts wmlFonts) throws Exception {
        for (String documentFontname : documentFontNames) {
            log.debug("Document font: " + documentFontname);
            PhysicalFont mappedTo = PhysicalFonts.get(documentFontname);
            if (mappedTo != null) {
                this.put(documentFontname, mappedTo);
                log.debug(".. mapped to " + mappedTo.getName());
                continue;
            }
            if (PhysicalFonts.get(documentFontname + " italic") != null) {
                this.put(documentFontname, PhysicalFonts.get(documentFontname + " italic"));
                log.debug(".. mismatch mapped to " + documentFontname + " italic");
                continue;
            }
            if (PhysicalFonts.get(documentFontname + " bold") != null) {
                this.put(documentFontname, PhysicalFonts.get(documentFontname + " bold"));
                log.debug(".. mismatch mapped to " + documentFontname + " bold");
                continue;
            }
            if (PhysicalFonts.get(documentFontname + " regular") != null) {
                this.put(documentFontname, PhysicalFonts.get(documentFontname + " regular"));
                log.debug(".. mismatch mapped to " + documentFontname + " regular");
                continue;
            }
            if (this.regularForms.get(documentFontname) != null) {
                this.put(documentFontname, (PhysicalFont)this.regularForms.get(documentFontname));
                log.debug(".. mapped to embedded regular form ");
                continue;
            }
            if (this.boldForms.get(documentFontname) != null) {
                this.put(documentFontname, (PhysicalFont)this.boldForms.get(documentFontname));
                log.debug(".. mapped to embedded bold form ");
                continue;
            }
            if (this.italicForms.get(documentFontname) != null) {
                this.put(documentFontname, (PhysicalFont)this.italicForms.get(documentFontname));
                log.debug(".. mapped to embedded italic form ");
                continue;
            }
            if (this.boldItalicForms.get(documentFontname) != null) {
                this.put(documentFontname, (PhysicalFont)this.boldItalicForms.get(documentFontname));
                log.debug(".. mapped to embedded bold italic form ");
                continue;
            }
            log.warn("- - No physical font for: " + documentFontname);
        }
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = "C:\\Documents and Settings\\Jason Harrop\\My Documents\\Downloads\\AUMS-easy.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        FontTablePart fontTablePart = wordMLPackage.getMainDocumentPart().getFontTablePart();
        Fonts fonts = (Fonts)fontTablePart.getJaxbElement();
        IdentityPlusMapper s = new IdentityPlusMapper();
        s.populateFontMappings(wordMLPackage.getMainDocumentPart().fontsInUse(), fonts);
    }

    static {
        try {
            int count = PhysicalFonts.discoverJarFonts("fonts-symbol");
            log.info("Found " + count + " docx4j symbol fonts.");
            if (Docx4jProperties.getProperty("org.docx4j.fonts.discoverJarFonts.enabled", true)) {
                PhysicalFonts.discoverJarFonts();
            }
            if (Docx4jProperties.getProperty("org.docx4j.fonts.discoverPhysicalFonts.enabled", true)) {
                PhysicalFonts.discoverPhysicalFonts();
            }
            PhysicalFonts.fontCache.save();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

