/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractExporterDelegate;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.events.EventFinished;
import org.docx4j.events.StartEvent;
import org.docx4j.events.WellKnownProcessSteps;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.ResourceUtils;
import org.w3c.dom.Document;

public abstract class AbstractXsltExporterDelegate<CS extends AbstractConversionSettings, CC extends AbstractWmlConversionContext>
extends AbstractExporterDelegate<CS, CC> {
    protected String defaultTemplatesResource = null;
    protected Templates defaultTemplates = null;

    protected AbstractXsltExporterDelegate(String defaultTemplatesResource) {
        this.defaultTemplatesResource = defaultTemplatesResource;
    }

    @Override
    public void process(CS conversionSettings, CC conversionContext, OutputStream outputStream) throws Docx4JException {
        StartEvent startEvent = new StartEvent(((AbstractConversionSettings)conversionSettings).getOpcPackage(), WellKnownProcessSteps.OUT_XsltExporterDelegate);
        startEvent.publish();
        Document domDoc = this.getSourceDocument(conversionSettings, conversionContext);
        Templates templates = this.getTemplates(conversionSettings, conversionContext);
        StreamResult intermediateResult = new StreamResult(outputStream);
        XmlUtils.transform(domDoc, templates, ((AbstractConversionContext)conversionContext).getXsltParameters(), (Result)intermediateResult);
        new EventFinished(startEvent).publish();
    }

    protected abstract Document getSourceDocument(CS var1, CC var2) throws Docx4JException;

    protected Templates getTemplates(CS conversionSettings, CC conversionContext) throws Docx4JException {
        Templates ret = (Templates)((AbstractConversionSettings)conversionSettings).getCustomXsltTemplates();
        return ret == null ? this.getDefaultTemplate() : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getDefaultTemplate() throws Docx4JException {
        if (this.defaultTemplates == null) {
            TransformerFactory transformerFactory = XmlUtils.getTransformerFactory();
            synchronized (transformerFactory) {
                if (this.defaultTemplates == null) {
                    this.defaultTemplates = this.loadDefaultTemplates();
                }
            }
        }
        return this.defaultTemplates;
    }

    protected Templates loadDefaultTemplates() throws Docx4JException {
        Templates ret = null;
        StreamSource xsltSource = null;
        try {
            xsltSource = new StreamSource(ResourceUtils.getResource(this.defaultTemplatesResource));
            ret = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            throw new Docx4JException("Exception loading default template \"" + this.defaultTemplatesResource + "\", " + e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("Exception loading default template \"" + this.defaultTemplatesResource + "\", " + e.getMessage(), e);
        }
        return ret;
    }
}

