/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml.renderer;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import java.awt.Rectangle;
import java.util.EnumMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.docx4j.convert.in.xhtml.renderer.Docx4jDocxOutputDevice;
import org.docx4j.convert.in.xhtml.renderer.Docx4jReplacedElementFactory;
import org.docx4j.convert.in.xhtml.renderer.Docx4jTextRenderer;
import org.docx4j.convert.in.xhtml.renderer.Docx4jUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DocxRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private final SharedContext _sharedContext;
    private final Docx4jDocxOutputDevice _outputDevice;
    private Document _doc;
    private BlockBox _root;
    private PDDocument _pdfDoc = new PDDocument();
    private PdfRendererBuilder.PdfAConformance _pdfAConformance;
    private boolean _pdfUaConformance;
    private Docx4jUserAgent userAgent;
    private LayoutContext _layoutContext;
    private final float _dotsPerPoint;

    public BlockBox getRootBox() {
        return this._root;
    }

    public Docx4jUserAgent getDocx4jUserAgent() {
        return this.userAgent;
    }

    public LayoutContext getLayoutContext() {
        return this._layoutContext;
    }

    public DocxRenderer() {
        this(new Docx4jUserAgent(), null, 26.666666f, 20);
    }

    public DocxRenderer(String extraCSS) {
        this(new Docx4jUserAgent(), DocxRenderer.readCSS(extraCSS), 26.666666f, 20);
    }

    public DocxRenderer(Docx4jUserAgent userAgent) {
        this(userAgent, null, 26.666666f, 20);
    }

    public DocxRenderer(float dotsPerPoint, int dotsPerPixel) {
        this(new Docx4jUserAgent(), null, dotsPerPoint, dotsPerPixel);
    }

    public DocxRenderer(Docx4jUserAgent userAgent, StylesheetInfo[] extraCSS, float dotsPerPoint, int dotsPerPixel) {
        this._dotsPerPoint = dotsPerPoint;
        this._outputDevice = new Docx4jDocxOutputDevice();
        this.userAgent = userAgent;
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext.setUserAgentCallback((UserAgentCallback)userAgent);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)userAgent));
        EnumMap _caches = new EnumMap(PdfRendererBuilder.CacheStore.class);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc, (FSCacheEx)_caches.get(PdfRendererBuilder.CacheStore.PDF_FONT_METRICS), PdfRendererBuilder.PdfAConformance.NONE, false);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        Docx4jReplacedElementFactory replacedElementFactory = new Docx4jReplacedElementFactory(this._outputDevice);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedElementFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new Docx4jTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    private static StylesheetInfo[] readCSS(String css) {
        String media = "all";
        StylesheetInfo info = new StylesheetInfo();
        info.setMedia(media);
        info.setType("text/css");
        info.setTitle("Word styles");
        info.setOrigin(2);
        info.setContent(css);
        StylesheetInfo[] array = new StylesheetInfo[]{info};
        return array;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public Document loadDocument(String uri) {
        return this._sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    public void setDocument(Document doc, String url) {
        this.setDocument(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    private void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        this._root = root;
        this._layoutContext = c;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        ((PdfBoxTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)new SimpleBidiReorderer());
        return result;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }

        public boolean isMarker(Element e) {
            return false;
        }
    }
}

