/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.msoffice.MicrosoftOfficeFormat;

enum MicrosoftPowerpointFormat implements MicrosoftOfficeFormat
{
    PDF("32", "pdf", DocumentType.PDF),
    PPTX("24", "pptx", DocumentType.PPTX),
    PPT("1", "ppt", DocumentType.PPT);

    private final String value;
    private final DocumentType documentType;
    private final String fileExtension;

    private MicrosoftPowerpointFormat(String value, String fileExtension, DocumentType documentType) {
        this.value = value;
        this.fileExtension = fileExtension;
        this.documentType = documentType;
    }

    public static MicrosoftPowerpointFormat of(DocumentType documentType) {
        for (MicrosoftPowerpointFormat enumeration : MicrosoftPowerpointFormat.values()) {
            if (!enumeration.documentType.equals((Object)documentType)) continue;
            return enumeration;
        }
        throw new IllegalArgumentException("Unknown document type: " + documentType);
    }

    public String getValue() {
        return this.value;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

