/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IFileConsumer;
import com.documents4j.api.IInputStreamConsumer;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FileConsumerToInputStreamConsumer
implements IInputStreamConsumer {
    private final File file;
    private final IFileConsumer fileConsumer;

    public FileConsumerToInputStreamConsumer(File file, IFileConsumer fileConsumer) {
        this.file = file;
        this.fileConsumer = fileConsumer;
    }

    public void onComplete(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            fileOutputStream.getChannel().lock();
            try {
                ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                Closeables.close((Closeable)inputStream, (boolean)true);
                Closeables.close((Closeable)fileOutputStream, (boolean)false);
            }
        }
        catch (IOException e) {
            throw new FileSystemInteractionException(String.format("Could not copy result to %s", this.file), (Throwable)e);
        }
        this.fileConsumer.onComplete(this.file);
    }

    public void onCancel() {
        this.fileConsumer.onCancel(this.file);
    }

    public void onException(Exception e) {
        this.fileConsumer.onException(this.file, e);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FileConsumerToInputStreamConsumer.class).add("file", (Object)this.file).add("fileConsumer", (Object)this.fileConsumer).toString();
    }
}

