/*
 * Decompiled with CFR 0.152.
 */
package org.opendope.conditions;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import java.util.Map;
import org.docx4j.Docx4jProperties;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Evaluable;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="xpathref")
public class Xpathref
implements Evaluable {
    private static Logger log = LoggerFactory.getLogger(Xpathref.class);
    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NCName")
    protected String id;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public boolean evaluate(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        String approach;
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        if (log.isDebugEnabled()) {
            log.debug("Evaluating " + xpath.getDataBinding().getXpath());
        }
        if ((approach = Docx4jProperties.getProperty("org.opendope.conditions.Xpathref.XPathBoolean", "false")).equals("cast1") || approach.equals("true") || approach.equals("cast2")) {
            if (log.isDebugEnabled()) {
                log.debug("Using XPath conversion rules for boolean: " + approach);
            }
            return Xpathref.xpathEval(pkg, customXmlDataStorageParts, xpath.getDataBinding().getStoreItemID(), xpath.getDataBinding().getXpath(), xpath.getDataBinding().getPrefixMappings());
        }
        if (log.isDebugEnabled()) {
            log.debug("Using Java to convert strings to boolean.");
        }
        String val = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, xpath.getDataBinding().getStoreItemID(), xpath.getDataBinding().getXpath(), xpath.getDataBinding().getPrefixMappings());
        return Boolean.parseBoolean(val);
    }

    public static boolean xpathEval(WordprocessingMLPackage pkg, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        log.debug(xpath + " with " + prefixMappings + " prefixMappings");
        if (xpath.contains("preceding-sibling")) {
            xpath = xpath.replace("][1]", "]");
        }
        try {
            if (storeItemId.toUpperCase().equals("{6C3C8BC8-F283-45AE-878A-BAB7291924A1}")) {
                return Boolean.parseBoolean(pkg.getDocPropsCorePart().xpathGetString(xpath, prefixMappings));
            }
            if (storeItemId.toUpperCase().equals("{6668398D-A668-4E3E-A5EB-62B293D839F1}")) {
                return Boolean.parseBoolean(pkg.getDocPropsExtendedPart().xpathGetString(xpath, prefixMappings));
            }
            CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
            if (part == null) {
                throw new InputIntegrityException("Couldn't locate part by storeItemId " + storeItemId);
            }
            return part.cachedXPathGetBoolean(xpath, prefixMappings);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InputIntegrityException(e.getMessage());
        }
    }

    @Override
    public void listXPaths(List<Xpaths.Xpath> theList, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        theList.add(xpath);
    }

    @Override
    public void mapIds(Map<String, String> xpathIdMap, Map<String, String> conditionIdMap) {
        if (xpathIdMap == null) {
            return;
        }
        String newId = xpathIdMap.get(this.getId());
        if (newId != null) {
            this.setId(newId);
        }
    }

    @Override
    public String toString(Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpath = xpathsMap.get(this.id);
        return xpath.getDataBinding().getXpath();
    }

    @Override
    public Condition repeat(String xpathBase, int index, Map<String, Condition> conditionsMap, Map<String, Xpaths.Xpath> xpathsMap) {
        Xpaths.Xpath xpathObj = xpathsMap.get(this.id);
        String thisXPath = xpathObj.getDataBinding().getXpath();
        int xpathBaseIdx = thisXPath.indexOf(xpathBase);
        if (xpathBaseIdx < 0) {
            return null;
        }
        if (thisXPath.trim().startsWith("count")) {
            int pos = xpathBaseIdx + xpathBase.length();
            String tail = thisXPath.substring(pos);
            log.debug("the tail: " + tail);
            if (tail.contains("oda:repeat")) {
                log.debug("deeper repeats in count");
            } else if (tail.contains("/")) {
                log.debug("deeper bits in count");
            } else if (tail.startsWith("[")) {
                log.debug("index needs enhancement");
            } else {
                if (tail.startsWith(")")) {
                    log.debug("retaining (repeat count): " + thisXPath);
                    return null;
                }
                log.info("fallback, enhance: " + thisXPath);
            }
        }
        String newPath = XPathEnhancerParser.enhanceXPath(xpathBase, index + 1, thisXPath);
        if (log.isDebugEnabled()) {
            if (thisXPath.equals(newPath)) {
                log.debug("xpath base " + xpathBase + " enhanced NO CHANGE to " + newPath);
            } else {
                log.debug("xpath " + thisXPath + " enhanced to " + newPath + " using xpath base " + xpathBase);
            }
        }
        Xpaths.Xpath newXPathObj = this.createNewXPathObject(xpathsMap, newPath, xpathObj, index);
        this.id = newXPathObj.getId();
        return null;
    }

    private Xpaths.Xpath createNewXPathObject(Map<String, Xpaths.Xpath> xpathsMap, String newPath, Xpaths.Xpath xpathObj, int index) {
        Xpaths.Xpath newXPathObj = new Xpaths.Xpath();
        String newXPathId = xpathObj.getId() + "_" + index;
        newXPathObj.setId(newXPathId);
        Xpaths.Xpath.DataBinding dataBinding = new Xpaths.Xpath.DataBinding();
        newXPathObj.setDataBinding(dataBinding);
        dataBinding.setXpath(newPath);
        dataBinding.setStoreItemID(xpathObj.getDataBinding().getStoreItemID());
        dataBinding.setPrefixMappings(xpathObj.getDataBinding().getPrefixMappings());
        Xpaths.Xpath preExistingSanity = xpathsMap.put(newXPathId, newXPathObj);
        if (preExistingSanity != null) {
            if (preExistingSanity.getDataBinding().getXpath().equals(newXPathObj.getDataBinding().getXpath())) {
                log.debug("Duplicate identical XPath being added: " + newXPathId);
            } else {
                log.error("Duplicate XPath " + newXPathId + ": \n" + newXPathObj.getDataBinding().getXpath() + " overwriting \n" + preExistingSanity.getDataBinding().getXpath());
            }
        }
        return newXPathObj;
    }
}

