/*
 * Decompiled with CFR 0.152.
 */
package org.glox4j.openpackaging.packages;

import java.io.File;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutHeaderPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutPart;
import org.docx4j.openpackaging.parts.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GloxPackage
extends OpcPackage {
    protected static Logger log = LoggerFactory.getLogger(GloxPackage.class);
    private DiagramLayoutPart diagramLayoutPart;
    private DiagramLayoutHeaderPart diagramLayoutHeaderPart;

    public GloxPackage() {
    }

    public GloxPackage(ContentTypeManager contentTypeManager) {
        super(contentTypeManager);
    }

    public static GloxPackage load(File gloxFile) throws Docx4JException {
        return (GloxPackage)OpcPackage.load(gloxFile);
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramLayout")) {
            this.diagramLayoutPart = (DiagramLayoutPart)part;
            log.info("Set shortcut for diagramLayoutPart");
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramLayoutHeader")) {
            this.diagramLayoutHeaderPart = (DiagramLayoutHeaderPart)part;
            log.info("Set shortcut for diagramLayoutHeaderPart");
            return true;
        }
        return false;
    }

    public DiagramLayoutPart getDiagramLayoutPart() {
        return this.diagramLayoutPart;
    }

    public DiagramLayoutHeaderPart getDiagramLayoutHeaderPart() {
        return this.diagramLayoutHeaderPart;
    }
}

