/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc.switches;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.toc.TocEntry;
import org.docx4j.toc.switches.OSwitch;
import org.docx4j.toc.switches.SelectorSwitch;
import org.docx4j.toc.switches.SwitchProcessorInterface;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USwitch
extends SelectorSwitch {
    private static Logger log = LoggerFactory.getLogger(USwitch.class);
    public static final String ID = "\\u";
    private static final int PRIORITY = 8;
    private Map<String, PPrBase.OutlineLvl> knownOutlineLevels = new HashMap<String, PPrBase.OutlineLvl>();
    private static PPrBase.OutlineLvl LEVEL_9 = new PPrBase.OutlineLvl();

    @Override
    public boolean hasFieldArgument() {
        return false;
    }

    @Override
    public void process(Style s, SwitchProcessorInterface sp) {
    }

    public void process(Style s, SwitchProcessorInterface sp, PPr pPr, OSwitch oSwitch) {
        int cutOff = 9;
        if (oSwitch != null && oSwitch.fieldArgument != null) {
            cutOff = oSwitch.getEndLevel();
        }
        int level = this.getOutlineLvl(pPr, sp, s, cutOff);
        if (log.isDebugEnabled()) {
            log.debug("outline level " + level);
        }
        if (level == 9) {
            sp.setSelected(false);
        } else {
            TocEntry te = sp.getEntry();
            te.setEntryLevel(level);
            sp.setSelected(true);
        }
    }

    @Override
    public int getPriority() {
        return 8;
    }

    public int getOutlineLvl(PPr pPr, SwitchProcessorInterface sp, Style s, int cutOff) {
        PPrBase.OutlineLvl outlineLvl = null;
        if (pPr != null) {
            outlineLvl = pPr.getOutlineLvl();
        }
        if (outlineLvl == null) {
            if (s == null) {
                return 9;
            }
            int hLevel = sp.getStyleBasedOnHelper().getBasedOnHeading(s);
            if (hLevel > cutOff) {
                return 9;
            }
            outlineLvl = this.knownOutlineLevels.get(s.getStyleId());
            if (outlineLvl == null) {
                PPr effectivePPr = sp.getPropertyResolver().getEffectivePPr(s.getStyleId());
                outlineLvl = effectivePPr.getOutlineLvl();
                if (outlineLvl == null) {
                    outlineLvl = LEVEL_9;
                }
                this.knownOutlineLevels.put(s.getStyleId(), outlineLvl);
            }
        }
        if (outlineLvl == null || outlineLvl.getVal() == null) {
            return 9;
        }
        return outlineLvl.getVal().intValue();
    }
}

