/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.apps.io.InternalResourceResolver;
import org.docx4j.fonts.fop.apps.io.ResourceResolverFactory;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EmbeddingMode;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontUris;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.AbstractFontPart;
import org.docx4j.openpackaging.parts.PartName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObfuscatedFontPart
extends AbstractFontPart {
    private static Logger log = LoggerFactory.getLogger(ObfuscatedFontPart.class);
    static CharSequence target = new String("-").subSequence(0, 1);
    static CharSequence replacement = new String("").subSequence(0, 0);

    public ObfuscatedFontPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.obfuscatedFont"));
    }

    @Deprecated
    public PhysicalFont deObfuscate(String fontNameAsInTablePart, String fontFileName, String fontKey, String filenamePrefix) {
        return this.extract(fontNameAsInTablePart, fontFileName, fontKey, filenamePrefix);
    }

    @Override
    public PhysicalFont extract(String fontNameAsInTablePart, String fontFileName, String fontKey, String filenamePrefix) {
        List<PhysicalFont> fonts;
        byte[] fontData = this.getBytes();
        log.debug("bytes: " + fontData.length);
        if (fontData.length == 0) {
            log.error(this.getF() + " is empty");
            return null;
        }
        log.info("deObfuscating '" + fontFileName + "' with fontkey: " + fontKey);
        String tmpString = fontKey.substring(1, fontKey.length() - 1);
        log.debug(tmpString);
        String guidString = tmpString.replace(target, replacement);
        log.debug(guidString);
        byte[] guidByteArray = new byte[16];
        for (int i = 0; i < guidByteArray.length; ++i) {
            guidByteArray[i] = ObfuscatedFontPart.fromHexString(guidString.substring(i * 2, i * 2 + 2));
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 16; ++i) {
                int n = j * 16 + i;
                fontData[n] = (byte)(fontData[n] ^ guidByteArray[15 - i]);
            }
        }
        this.setF(new File(ObfuscatedFontPart.getTmpFontDir(), filenamePrefix + "-" + fontFileName + ".ttf"));
        this.getF().deleteOnExit();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getF());
            fos.write(fontData);
            log.debug("wrote: " + fontData.length);
            fos.close();
        }
        catch (IOException e) {
            log.error("Problem with " + this.getF());
            log.error(e.getMessage(), (Throwable)e);
        }
        URI baseUri = null;
        try {
            baseUri = new URI("/");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        InternalResourceResolver fontResolver = new InternalResourceResolver(baseUri, ResourceResolverFactory.createDefaultResourceResolver());
        if (log.isDebugEnabled()) {
            CustomFont customFont = null;
            try {
                log.debug("[DEBUG] Loading from: " + this.getF());
                String subFontName = null;
                boolean embedded = true;
                boolean useKerning = true;
                boolean useAdvanced = false;
                boolean simulateStyle = false;
                boolean embedAsType1 = false;
                FontUris fontUris = new FontUris(this.getF().toURI(), null);
                customFont = FontLoader.loadFont(fontUris, subFontName, embedded, EmbeddingMode.AUTO, EncodingMode.AUTO, useKerning, useAdvanced, fontResolver, simulateStyle, embedAsType1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (customFont != null) {
                log.info("Successfully reloaded " + customFont.getFontName());
                if (customFont.isEmbeddable()) {
                    log.debug("confirmed embeddable");
                } else {
                    log.error("this embedded font claims it is not embeddable!");
                }
            }
        }
        return (fonts = PhysicalFonts.getPhysicalFont(fontNameAsInTablePart, this.getF().toURI())) == null || fonts.isEmpty() ? null : fonts.iterator().next();
    }

    public static byte fromHexString(String hexStr) {
        byte firstNibble = Byte.parseByte(hexStr.substring(0, 1), 16);
        byte secondNibble = Byte.parseByte(hexStr.substring(1, 2), 16);
        int finalByte = secondNibble | firstNibble << 4;
        return (byte)finalByte;
    }

    protected static void deleteEmbeddedFontTempFiles(String filenamePrefix) {
        int count;
        if (ObfuscatedFontPart.getTmpFontDir() == null) {
            log.warn("TmpFontDir is null");
            return;
        }
        for (File f : ObfuscatedFontPart.getTmpFontDir().listFiles()) {
            if (!f.getName().startsWith(filenamePrefix)) continue;
            f.delete();
        }
        if (log.isWarnEnabled() && (count = ObfuscatedFontPart.getTmpFontDir().listFiles().length) > 0) {
            try {
                log.warn(count + " files remain in " + ObfuscatedFontPart.getTmpFontDir().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (deleteFileOnFinalize && this.getF() != null) {
                log.debug("Deleting  " + this.getF().getName());
                this.getF().delete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }
}

