/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import org.docx4j.model.listnumbering.NumberFormatChineseLower;
import org.docx4j.model.listnumbering.NumberFormatChineseUpper;
import org.docx4j.model.listnumbering.NumberFormatDecimalEnclosedCircle;
import org.docx4j.model.listnumbering.NumberFormatDecimalZero;
import org.docx4j.model.listnumbering.NumberFormatLowerLetter;
import org.docx4j.model.listnumbering.NumberFormatRomanLower;
import org.docx4j.model.listnumbering.NumberFormatRomanUpper;
import org.docx4j.wml.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFormatter {
    protected static Logger log = LoggerFactory.getLogger(NumberFormatter.class);

    public static String getCurrentValueFormatted(NumberFormat numFmt, String num) {
        try {
            return NumberFormatter.getCurrentValueFormatted(numFmt, Integer.parseInt(num));
        }
        catch (NumberFormatException e) {
            log.error("'" + num + "' is NaN");
            return "1";
        }
    }

    public static String getCurrentValueFormatted(NumberFormat numFmt, int current) {
        if (numFmt.equals((Object)NumberFormat.DECIMAL)) {
            return "" + current;
        }
        if (numFmt.equals((Object)NumberFormat.NONE)) {
            return "";
        }
        if (numFmt.equals((Object)NumberFormat.BULLET)) {
            return "*";
        }
        if (numFmt.equals((Object)NumberFormat.UPPER_ROMAN)) {
            NumberFormatRomanUpper converter = new NumberFormatRomanUpper();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.LOWER_ROMAN)) {
            NumberFormatRomanLower converter = new NumberFormatRomanLower();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.LOWER_LETTER)) {
            NumberFormatLowerLetter converter = new NumberFormatLowerLetter();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.UPPER_LETTER)) {
            NumberFormatLowerLetter converter = new NumberFormatLowerLetter();
            return converter.format(current).toUpperCase();
        }
        if (numFmt.equals((Object)NumberFormat.DECIMAL_ZERO)) {
            NumberFormatDecimalZero converter = new NumberFormatDecimalZero();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.CHINESE_COUNTING) || numFmt.equals((Object)NumberFormat.CHINESE_COUNTING_THOUSAND)) {
            NumberFormatChineseLower converter = new NumberFormatChineseLower();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.CHINESE_LEGAL_SIMPLIFIED)) {
            NumberFormatChineseUpper converter = new NumberFormatChineseUpper();
            return converter.format(current);
        }
        if (numFmt.equals((Object)NumberFormat.DECIMAL_ENCLOSED_CIRCLE) || numFmt.equals((Object)NumberFormat.DECIMAL_ENCLOSED_CIRCLE_CHINESE)) {
            NumberFormatDecimalEnclosedCircle converter = new NumberFormatDecimalEnclosedCircle();
            return converter.format(current);
        }
        log.error("Unhandled numFmt: " + numFmt.name());
        return "" + current;
    }
}

