/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.writer.SymbolUtils;
import org.docx4j.convert.out.html.SymbolWriter;
import org.docx4j.finders.SdtFinder;
import org.docx4j.finders.TcFinder;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.AbstractListNumberingDefinition;
import org.docx4j.model.listnumbering.ListLevel;
import org.docx4j.model.listnumbering.ListNumberingDefinition;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContent;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListsToContentControls {
    public static Logger log = LoggerFactory.getLogger(ListsToContentControls.class);
    private WordprocessingMLPackage wmlPackage;
    private MainDocumentPart mainDocument;
    private NumberingDefinitionsPart ndp;
    private StyleDefinitionsPart stylesPart;
    private PropertyResolver propertyResolver;
    private LinkedList<ListSpec> listStack = null;

    public ListsToContentControls(WordprocessingMLPackage wmlPackage) {
        this.wmlPackage = wmlPackage;
        this.mainDocument = wmlPackage.getMainDocumentPart();
        this.ndp = this.mainDocument.getNumberingDefinitionsPart();
        this.stylesPart = wmlPackage.getMainDocumentPart().getStyleDefinitionsPart();
        this.propertyResolver = wmlPackage.getMainDocumentPart().getPropertyResolver();
    }

    public static void process(WordprocessingMLPackage wmlPackage) {
        ListsToContentControls lc = new ListsToContentControls(wmlPackage);
        if (lc.ndp == null) {
            log.info("No NumberingDefinitionsPart, skipping");
            return;
        }
        lc.process();
    }

    private void process() {
        List content = null;
        List<Object> groupedContent = null;
        SdtFinder sdtFinder = new SdtFinder();
        new TraversalUtil(this.mainDocument.getContent(), sdtFinder);
        for (SdtElement sdtEl : sdtFinder.getSdtList()) {
            content = sdtEl.getSdtContent().getContent();
            groupedContent = this.groupContent(content);
            if (groupedContent == null) continue;
            content.clear();
            content.addAll(groupedContent);
        }
        TcFinder tcFinder = new TcFinder();
        tcFinder.setTraverseTables(true);
        new TraversalUtil(this.mainDocument.getContent(), tcFinder);
        for (Tc tc : tcFinder.tcList) {
            content = tc.getContent();
            groupedContent = this.groupContent(content);
            if (groupedContent == null) continue;
            content.clear();
            content.addAll(groupedContent);
        }
        content = this.mainDocument.getContent();
        groupedContent = this.groupContent(content);
        if (groupedContent != null) {
            content.clear();
            content.addAll(groupedContent);
        }
    }

    private void closeAllLists() {
        this.listStack.clear();
    }

    private void setTag(SdtBlock sdtList, BigInteger numId, BigInteger ilvl) {
        SdtPr sdtPr = new SdtPr();
        Tag tag = new Tag();
        sdtPr.setTag(tag);
        sdtList.setSdtPr(sdtPr);
        ListNumberingDefinition lnd = this.ndp.getInstanceListDefinitions().get(numId.toString());
        if (lnd == null) {
            log.warn("Couldn't find instance list for numId " + numId);
            tag.setVal("HTML_ELEMENT=OL");
            return;
        }
        AbstractListNumberingDefinition ald = lnd.getAbstractListDefinition();
        if (ald == null) {
            log.warn("Couldn't find abstract list for instance list " + numId);
            tag.setVal("HTML_ELEMENT=OL");
            return;
        }
        ListLevel level = ald.getListLevels().get(ilvl.toString());
        if (level == null) {
            log.warn("Couldn't find level " + ilvl.toString() + " in instance list ");
            tag.setVal("HTML_ELEMENT=OL");
            return;
        }
        if (level.IsBullet()) {
            if (level.getLevelText() == null) {
                tag.setVal("HTML_ELEMENT=UL");
            } else {
                String font = this.getFont(level.getJaxbAbstractLvl());
                if (level.getJaxbAbstractLvl().getLvlPicBulletId() != null) {
                    log.warn("w:lvlPicBulletId not supported; falling back to w:lvlText");
                }
                log.debug("Font: " + font);
                if (font == null) {
                    tag.setVal("HTML_ELEMENT=UL");
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Processing '" + level.getLevelText() + "'");
                    }
                    byte[] valBytes = SymbolUtils.hexStringToByteArray(Integer.toHexString(level.getLevelText().codePointAt(0)));
                    tag.setVal("HTML_ELEMENT=UL&lvlText=" + SymbolWriter.getReplacement(valBytes, font));
                }
            }
        } else {
            tag.setVal("HTML_ELEMENT=OL");
        }
    }

    private String getFont(Lvl lvl) {
        if (lvl.getRPr() == null) {
            log.warn("Missing rPr in " + XmlUtils.marshaltoString(lvl));
            return null;
        }
        if (lvl.getRPr().getRFonts() == null) {
            log.warn("Missing w:rFonts in " + XmlUtils.marshaltoString(lvl));
            return null;
        }
        RFonts rFonts = lvl.getRPr().getRFonts();
        if (rFonts.getHAnsi() != null) {
            String actualFontName = rFonts.getHAnsi();
            if (actualFontName.equals("Symbol") || actualFontName.equals("Webdings") || actualFontName.equals("Wingdings") || actualFontName.equals("Wingdings 2") || actualFontName.equals("Wingdings 3")) {
                return actualFontName;
            }
            log.warn(actualFontName + " no font mapping for this?");
            return actualFontName;
        }
        if (rFonts.getAscii() != null) {
            log.debug("getAscii() fallback");
            return rFonts.getAscii();
        }
        log.warn("Handle w:rFonts in " + XmlUtils.marshaltoString(lvl));
        return null;
    }

    private List<Object> groupContent(List<Object> bodyElts) {
        this.listStack = new LinkedList();
        ArrayList<Object> resultElts = new ArrayList<Object>();
        P paragraph = null;
        for (Object o : bodyElts) {
            Object unwrapped = o instanceof JAXBElement ? ((JAXBElement)o).getValue() : o;
            if (unwrapped instanceof P) {
                int i;
                Style s;
                paragraph = (P)unwrapped;
                PPr ppr = this.propertyResolver.getEffectivePPr(paragraph.getPPr());
                PPrBase.NumPr numPr = ppr.getNumPr();
                if (numPr == null) {
                    this.closeAllLists();
                    resultElts.add(unwrapped);
                    continue;
                }
                if (paragraph.getPPr() != null && paragraph.getPPr().getPStyle() != null && (s = this.propertyResolver.getStyle(paragraph.getPPr().getPStyle().getVal())).getName() != null && s.getName().getVal().startsWith("heading ")) {
                    this.closeAllLists();
                    resultElts.add(unwrapped);
                    continue;
                }
                BigInteger numId = numPr.getNumId().getVal();
                BigInteger ilvl = null;
                ilvl = numPr.getIlvl() == null ? BigInteger.ZERO : numPr.getIlvl().getVal();
                log.debug("ilvl: " + ilvl.intValue());
                ListSpec listSpec = this.listStack.peek();
                if (listSpec == null || numId != null && !numId.equals(listSpec.numId)) {
                    log.debug("NEW LIST");
                    if (listSpec != null) {
                        this.closeAllLists();
                    }
                    for (i = 0; i <= ilvl.intValue(); ++i) {
                        log.debug("adding level " + i);
                        listSpec = new ListSpec(numId, BigInteger.valueOf(i));
                        listSpec.sdtList = new SdtBlock();
                        this.setTag(listSpec.sdtList, numId, ilvl);
                        listSpec.sdtList.setSdtContent((SdtContent)new SdtContentBlock());
                        if (this.listStack.peek() == null) {
                            resultElts.add(listSpec.sdtList);
                        } else {
                            this.listStack.peek().sdtList.getSdtContent().getContent().add(listSpec.sdtList);
                        }
                        this.listStack.push(listSpec);
                    }
                    listSpec.sdtList.getSdtContent().getContent().add(paragraph);
                    continue;
                }
                if (numId == null) {
                    log.error("TODO: encountered null numId!");
                    this.closeAllLists();
                    resultElts.add(unwrapped);
                    continue;
                }
                log.debug("listSpec.ilvl.intValue():" + listSpec.ilvl.intValue());
                if (ilvl.equals(listSpec.ilvl)) {
                    log.debug("same level");
                } else if (ilvl.compareTo(listSpec.ilvl) > 0) {
                    for (i = listSpec.ilvl.intValue() + 1; i <= ilvl.intValue(); ++i) {
                        log.debug("adding level " + i);
                        listSpec = new ListSpec(numId, BigInteger.valueOf(i));
                        listSpec.sdtList = new SdtBlock();
                        this.setTag(listSpec.sdtList, numId, ilvl);
                        listSpec.sdtList.setSdtContent((SdtContent)new SdtContentBlock());
                        if (this.listStack.peek() == null) {
                            resultElts.add(listSpec.sdtList);
                        } else {
                            this.listStack.peek().sdtList.getSdtContent().getContent().add(listSpec.sdtList);
                        }
                        this.listStack.push(listSpec);
                    }
                } else {
                    log.debug("must be pop...");
                    for (i = listSpec.ilvl.intValue(); i > ilvl.intValue(); --i) {
                        log.debug("popping");
                        this.listStack.pop();
                        listSpec = this.listStack.peek();
                        log.debug("popped!");
                    }
                }
                listSpec.sdtList.getSdtContent().getContent().add(paragraph);
                continue;
            }
            if (unwrapped instanceof Tbl) {
                this.closeAllLists();
                resultElts.add(unwrapped);
                continue;
            }
            log.warn("TODO: handle " + unwrapped.getClass().getName());
            this.closeAllLists();
            resultElts.add(o);
        }
        return resultElts;
    }

    public static class ListSpec {
        BigInteger ilvl;
        BigInteger numId;
        SdtBlock sdtList = null;

        ListSpec(BigInteger numId, BigInteger ilvl) {
            this.numId = numId;
            this.ilvl = ilvl;
        }
    }
}

