/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.resource;

import com.openhtmltopdf.resource.Resource;
import com.openhtmltopdf.util.OpenUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.xml.sax.InputSource;

public abstract class AbstractResource
implements Resource,
Closeable {
    private final StreamType streamType;
    private InputSource inputSource;
    private final InputStream inputStream;
    private Reader inputReader;
    private final long createTimeStamp = System.currentTimeMillis();
    private long elapsedLoadTime;

    private AbstractResource(StreamType streamType, InputSource source, Reader reader, InputStream stream) {
        this.streamType = streamType;
        this.inputSource = source;
        this.inputReader = reader;
        this.inputStream = stream;
    }

    public AbstractResource(InputSource source) {
        this(StreamType.INPUT_SOURCE, source, null, null);
    }

    public AbstractResource(Reader reader) {
        this(StreamType.READER, null, reader, null);
    }

    public AbstractResource(InputStream is) {
        this(StreamType.STREAM, null, null, is);
    }

    @Override
    public void close() throws IOException {
        OpenUtil.closeQuietly(this.inputReader);
        OpenUtil.closeQuietly(this.inputStream);
    }

    @Override
    public InputSource getResourceInputSource() {
        if (this.streamType == StreamType.STREAM && this.inputSource == null) {
            this.inputSource = new InputSource(new BufferedInputStream(this.inputStream));
        }
        return this.inputSource;
    }

    public Reader getResourceReader() {
        if (this.streamType == StreamType.STREAM && this.inputReader == null) {
            this.inputReader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
        }
        return this.inputReader;
    }

    public InputStream getResourceInputStream() {
        return this.inputStream;
    }

    @Override
    public long getResourceLoadTimeStamp() {
        return this.createTimeStamp;
    }

    public long getElapsedLoadTime() {
        return this.elapsedLoadTime;
    }

    public void setElapsedLoadTime(long elapsedLoadTime) {
        this.elapsedLoadTime = elapsedLoadTime;
    }

    private static enum StreamType {
        READER,
        STREAM,
        INPUT_SOURCE;

    }
}

