/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiObject;
import net.arnx.wmf2svg.gdi.GdiPalette;
import net.arnx.wmf2svg.gdi.GdiPatternBrush;
import net.arnx.wmf2svg.gdi.GdiPen;
import net.arnx.wmf2svg.gdi.GdiRegion;
import net.arnx.wmf2svg.gdi.GdiUtils;
import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.Size;
import net.arnx.wmf2svg.gdi.svg.SvgBrush;
import net.arnx.wmf2svg.gdi.svg.SvgDc;
import net.arnx.wmf2svg.gdi.svg.SvgFont;
import net.arnx.wmf2svg.gdi.svg.SvgGdiException;
import net.arnx.wmf2svg.gdi.svg.SvgObject;
import net.arnx.wmf2svg.gdi.svg.SvgPalette;
import net.arnx.wmf2svg.gdi.svg.SvgPatternBrush;
import net.arnx.wmf2svg.gdi.svg.SvgPen;
import net.arnx.wmf2svg.gdi.svg.SvgRectRegion;
import net.arnx.wmf2svg.util.Base64;
import net.arnx.wmf2svg.util.ImageUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SvgGdi
implements Gdi {
    private static Logger log = Logger.getLogger(SvgGdi.class.getName());
    private boolean compatible;
    private boolean replaceSymbolFont = false;
    private Properties props = new Properties();
    private SvgDc dc;
    private LinkedList<SvgDc> saveDC = new LinkedList();
    private Document doc = null;
    private Element parentNode = null;
    private Element styleNode = null;
    private Element defsNode = null;
    private int brushNo = 0;
    private int fontNo = 0;
    private int penNo = 0;
    private int patternNo = 0;
    private int rgnNo = 0;
    private int clipPathNo = 0;
    private int maskNo = 0;
    private Map<GdiObject, String> nameMap = new HashMap<GdiObject, String>();
    private StringBuffer buffer = new StringBuffer();
    private SvgBrush defaultBrush;
    private SvgPen defaultPen;
    private SvgFont defaultFont;

    public SvgGdi() throws SvgGdiException {
        this(false);
    }

    public SvgGdi(boolean compatible) throws SvgGdiException {
        this.compatible = compatible;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SvgGdiException(e);
        }
        DOMImplementation dom = builder.getDOMImplementation();
        this.doc = dom.createDocument("http://www.w3.org/2000/svg", "svg", null);
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("SvgGdi.properties");
            this.props.load(in);
        }
        catch (Exception e) {
            throw new SvgGdiException("properties format error: SvgGDI.properties");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void write(OutputStream out) throws IOException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.0//EN");
            transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
            transformer.transform(new DOMSource(this.doc), new StreamResult(out));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        out.flush();
    }

    public void setCompatible(boolean flag) {
        this.compatible = flag;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setReplaceSymbolFont(boolean flag) {
        this.replaceSymbolFont = flag;
    }

    public boolean isReplaceSymbolFont() {
        return this.replaceSymbolFont;
    }

    public SvgDc getDC() {
        return this.dc;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getDefsElement() {
        return this.defsNode;
    }

    public Element getStyleElement() {
        return this.styleNode;
    }

    @Override
    public void placeableHeader(int wsx, int wsy, int wex, int wey, int dpi) {
        if (this.parentNode == null) {
            this.init();
        }
        this.dc.setWindowExtEx(Math.abs(wex - wsx), Math.abs(wey - wsy), null);
        this.dc.setDpi(dpi);
        Element root = this.doc.getDocumentElement();
        root.setAttribute("width", "" + (double)Math.abs(wex - wsx) / (double)this.dc.getDpi() + "in");
        root.setAttribute("height", "" + (double)Math.abs(wey - wsy) / (double)this.dc.getDpi() + "in");
    }

    @Override
    public void header() {
        if (this.parentNode == null) {
            this.init();
        }
    }

    private void init() {
        this.dc = new SvgDc(this);
        Element root = this.doc.getDocumentElement();
        root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.defsNode = this.doc.createElement("defs");
        root.appendChild(this.defsNode);
        this.styleNode = this.doc.createElement("style");
        this.styleNode.setAttribute("type", "text/css");
        root.appendChild(this.styleNode);
        this.parentNode = this.doc.createElement("g");
        this.doc.getDocumentElement().appendChild(this.parentNode);
        this.defaultBrush = (SvgBrush)this.createBrushIndirect(0, 0xFFFFFF, 0);
        this.defaultPen = (SvgPen)this.createPenIndirect(0, 1, 0);
        this.defaultFont = null;
        this.dc.setBrush(this.defaultBrush);
        this.dc.setPen(this.defaultPen);
        this.dc.setFont(this.defaultFont);
    }

    @Override
    public void animatePalette(GdiPalette palette, int startIndex, int[] entries) {
        log.fine("not implemented: animatePalette");
    }

    @Override
    public void arc(int sxr, int syr, int exr, int eyr, int sxa, int sya, int exa, int eya) {
        double rx = (double)Math.abs(exr - sxr) / 2.0;
        double ry = (double)Math.abs(eyr - syr) / 2.0;
        if (rx <= 0.0 || ry <= 0.0) {
            return;
        }
        double cx = (double)Math.min(sxr, exr) + rx;
        double cy = (double)Math.min(syr, eyr) + ry;
        Element elem = null;
        if (sxa == exa && sya == eya) {
            if (rx == ry) {
                elem = this.doc.createElement("circle");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("r", "" + this.dc.toRelativeX(rx));
            } else {
                elem = this.doc.createElement("ellipse");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("rx", "" + this.dc.toRelativeX(rx));
                elem.setAttribute("ry", "" + this.dc.toRelativeY(ry));
            }
        } else {
            double sa = Math.atan2(((double)sya - cy) * rx, ((double)sxa - cx) * ry);
            double sx = rx * Math.cos(sa);
            double sy = ry * Math.sin(sa);
            double ea = Math.atan2(((double)eya - cy) * rx, ((double)exa - cx) * ry);
            double ex = rx * Math.cos(ea);
            double ey = ry * Math.sin(ea);
            double a = Math.atan2((ex - sx) * -sy - (ey - sy) * -sx, (ex - sx) * -sx + (ey - sy) * -sy);
            elem = this.doc.createElement("path");
            elem.setAttribute("d", "M " + this.dc.toAbsoluteX(sx + cx) + "," + this.dc.toAbsoluteY(sy + cy) + " A " + this.dc.toRelativeX(rx) + "," + this.dc.toRelativeY(ry) + " 0 " + (a > 0.0 ? "1" : "0") + " 0 " + this.dc.toAbsoluteX(ex + cx) + "," + this.dc.toAbsoluteY(ey + cy));
        }
        if (this.dc.getPen() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        elem.setAttribute("fill", "none");
        this.parentNode.appendChild(elem);
    }

    @Override
    public void bitBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, long rop) {
        this.bmpToSvg(image, dx, dy, dw, dh, sx, sy, dw, dh, 0, rop);
    }

    @Override
    public void chord(int sxr, int syr, int exr, int eyr, int sxa, int sya, int exa, int eya) {
        double rx = (double)Math.abs(exr - sxr) / 2.0;
        double ry = (double)Math.abs(eyr - syr) / 2.0;
        if (rx <= 0.0 || ry <= 0.0) {
            return;
        }
        double cx = (double)Math.min(sxr, exr) + rx;
        double cy = (double)Math.min(syr, eyr) + ry;
        Element elem = null;
        if (sxa == exa && sya == eya) {
            if (rx == ry) {
                elem = this.doc.createElement("circle");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("r", "" + this.dc.toRelativeX(rx));
            } else {
                elem = this.doc.createElement("ellipse");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("rx", "" + this.dc.toRelativeX(rx));
                elem.setAttribute("ry", "" + this.dc.toRelativeY(ry));
            }
        } else {
            double sa = Math.atan2(((double)sya - cy) * rx, ((double)sxa - cx) * ry);
            double sx = rx * Math.cos(sa);
            double sy = ry * Math.sin(sa);
            double ea = Math.atan2(((double)eya - cy) * rx, ((double)exa - cx) * ry);
            double ex = rx * Math.cos(ea);
            double ey = ry * Math.sin(ea);
            double a = Math.atan2((ex - sx) * -sy - (ey - sy) * -sx, (ex - sx) * -sx + (ey - sy) * -sy);
            elem = this.doc.createElement("path");
            elem.setAttribute("d", "M " + this.dc.toAbsoluteX(sx + cx) + "," + this.dc.toAbsoluteY(sy + cy) + " A " + this.dc.toRelativeX(rx) + "," + this.dc.toRelativeY(ry) + " 0 " + (a > 0.0 ? "1" : "0") + " 0 " + this.dc.toAbsoluteX(ex + cx) + "," + this.dc.toAbsoluteY(ey + cy) + " Z");
        }
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
        }
        this.parentNode.appendChild(elem);
    }

    @Override
    public GdiBrush createBrushIndirect(int style, int color, int hatch) {
        SvgBrush brush = new SvgBrush(this, style, color, hatch);
        if (!this.nameMap.containsKey(brush)) {
            String name = "brush" + this.brushNo++;
            this.nameMap.put(brush, name);
            this.styleNode.appendChild(brush.createTextNode(name));
        }
        return brush;
    }

    @Override
    public GdiFont createFontIndirect(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, int charset, int outPrecision, int clipPrecision, int quality, int pitchAndFamily, byte[] faceName) {
        SvgFont font = new SvgFont(this, height, width, escapement, orientation, weight, italic, underline, strikeout, charset, outPrecision, clipPrecision, quality, pitchAndFamily, faceName);
        if (!this.nameMap.containsKey(font)) {
            String name = "font" + this.fontNo++;
            this.nameMap.put(font, name);
            this.styleNode.appendChild(font.createTextNode(name));
        }
        return font;
    }

    @Override
    public GdiPalette createPalette(int version, int[] entries) {
        return new SvgPalette(this, version, entries);
    }

    @Override
    public GdiPatternBrush createPatternBrush(byte[] image) {
        return new SvgPatternBrush(this, image);
    }

    @Override
    public GdiPen createPenIndirect(int style, int width, int color) {
        SvgPen pen = new SvgPen(this, style, width, color);
        if (!this.nameMap.containsKey(pen)) {
            String name = "pen" + this.penNo++;
            this.nameMap.put(pen, name);
            this.styleNode.appendChild(pen.createTextNode(name));
        }
        return pen;
    }

    @Override
    public GdiRegion createRectRgn(int left, int top, int right, int bottom) {
        SvgRectRegion rgn = new SvgRectRegion(this, left, top, right, bottom);
        if (!this.nameMap.containsKey(rgn)) {
            this.nameMap.put(rgn, "rgn" + this.rgnNo++);
            this.defsNode.appendChild(rgn.createElement());
        }
        return rgn;
    }

    @Override
    public void deleteObject(GdiObject obj) {
        if (this.dc.getBrush() == obj) {
            this.dc.setBrush(this.defaultBrush);
        } else if (this.dc.getFont() == obj) {
            this.dc.setFont(this.defaultFont);
        } else if (this.dc.getPen() == obj) {
            this.dc.setPen(this.defaultPen);
        }
    }

    @Override
    public void dibBitBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, long rop) {
        this.bitBlt(image, dx, dy, dw, dh, sx, sy, rop);
    }

    @Override
    public GdiPatternBrush dibCreatePatternBrush(byte[] image, int usage) {
        return new SvgPatternBrush(this, image);
    }

    @Override
    public void dibStretchBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, long rop) {
        this.stretchDIBits(dx, dy, dw, dh, sx, sy, sw, sh, image, 0, rop);
    }

    @Override
    public void ellipse(int sx, int sy, int ex, int ey) {
        Element elem = this.doc.createElement("ellipse");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
        }
        elem.setAttribute("cx", "" + (int)this.dc.toAbsoluteX((sx + ex) / 2));
        elem.setAttribute("cy", "" + (int)this.dc.toAbsoluteY((sy + ey) / 2));
        elem.setAttribute("rx", "" + (int)this.dc.toRelativeX((ex - sx) / 2));
        elem.setAttribute("ry", "" + (int)this.dc.toRelativeY((ey - sy) / 2));
        this.parentNode.appendChild(elem);
    }

    @Override
    public void escape(byte[] data) {
    }

    @Override
    public int excludeClipRect(int left, int top, int right, int bottom) {
        Element mask = this.dc.getMask();
        if (mask != null) {
            mask = (Element)mask.cloneNode(true);
            String name = "mask" + this.maskNo++;
            mask.setAttribute("id", name);
            this.defsNode.appendChild(mask);
            Element unclip = this.doc.createElement("rect");
            unclip.setAttribute("x", "" + (int)this.dc.toAbsoluteX(left));
            unclip.setAttribute("y", "" + (int)this.dc.toAbsoluteY(top));
            unclip.setAttribute("width", "" + (int)this.dc.toRelativeX(right - left));
            unclip.setAttribute("height", "" + (int)this.dc.toRelativeY(bottom - top));
            unclip.setAttribute("fill", "black");
            mask.appendChild(unclip);
            this.dc.setMask(mask);
            return 3;
        }
        return 1;
    }

    @Override
    public void extFloodFill(int x, int y, int color, int type) {
        log.fine("not implemented: extFloodFill");
    }

    @Override
    public void extTextOut(int x, int y, int options, int[] rect, byte[] text, int[] dx) {
        Element elem = this.doc.createElement("text");
        int escapement = 0;
        boolean vertical = false;
        if (this.dc.getFont() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getFont()));
            if (this.dc.getFont().getFaceName().startsWith("@")) {
                vertical = true;
                escapement = this.dc.getFont().getEscapement() - 2700;
            } else {
                escapement = this.dc.getFont().getEscapement();
            }
        }
        elem.setAttribute("fill", SvgObject.toColor(this.dc.getTextColor()));
        this.buffer.setLength(0);
        int align = this.dc.getTextAlign();
        if ((align & 6) == 2) {
            this.buffer.append("text-anchor: end; ");
        } else if ((align & 6) == 6) {
            this.buffer.append("text-anchor: middle; ");
        }
        if (this.compatible) {
            this.buffer.append("dominant-baseline: alphabetic; ");
        } else if (vertical) {
            elem.setAttribute("writing-mode", "tb");
        } else if ((align & 0x18) == 24) {
            this.buffer.append("dominant-baseline: alphabetic; ");
        } else {
            this.buffer.append("dominant-baseline: text-before-edge; ");
        }
        if ((align & 0x100) == 256 || (options & 0x80) > 0) {
            this.buffer.append("unicode-bidi: bidi-override; direction: rtl; ");
        }
        if (this.dc.getTextSpace() > 0) {
            this.buffer.append("word-spacing: ").append(this.dc.getTextSpace()).append("; ");
        }
        if (this.buffer.length() > 0) {
            this.buffer.setLength(this.buffer.length() - 1);
            elem.setAttribute("style", this.buffer.toString());
        }
        elem.setAttribute("stroke", "none");
        if ((align & 1) == 1) {
            x = this.dc.getCurrentX();
            y = this.dc.getCurrentY();
        }
        int ax = (int)this.dc.toAbsoluteX(x);
        int width = 0;
        if (vertical) {
            elem.setAttribute("x", Integer.toString(ax));
            if (this.dc.getFont() != null) {
                width = Math.abs(this.dc.getFont().getFontSize());
            }
        } else {
            if (this.dc.getFont() != null) {
                dx = this.dc.getFont().validateDx(text, dx);
            }
            if (dx != null && dx.length > 0) {
                for (int i = 0; i < dx.length; ++i) {
                    width += dx[i];
                }
                int tx = x;
                if ((align & 6) == 2) {
                    tx -= width - dx[dx.length - 1];
                } else if ((align & 6) == 6) {
                    tx -= (width - dx[dx.length - 1]) / 2;
                }
                this.buffer.setLength(0);
                for (int i = 0; i < dx.length; ++i) {
                    if (i > 0) {
                        this.buffer.append(" ");
                    }
                    this.buffer.append((int)this.dc.toAbsoluteX(tx));
                    tx += dx[i];
                }
                if ((align & 1) == 1) {
                    this.dc.moveToEx(tx, y, null);
                }
                elem.setAttribute("x", this.buffer.toString());
            } else {
                if (this.dc.getFont() != null) {
                    width = Math.abs(this.dc.getFont().getFontSize() * text.length) / 2;
                }
                elem.setAttribute("x", Integer.toString(ax));
            }
        }
        int ay = (int)this.dc.toAbsoluteY(y);
        int height = 0;
        if (vertical) {
            if (this.dc.getFont() != null) {
                dx = this.dc.getFont().validateDx(text, dx);
            }
            this.buffer.setLength(0);
            if (align == 0) {
                this.buffer.append(ay + (int)this.dc.toRelativeY(Math.abs(this.dc.getFont().getHeight())));
            } else {
                this.buffer.append(ay);
            }
            if (dx != null && dx.length > 0) {
                for (int i = 0; i < dx.length - 1; ++i) {
                    height += dx[i];
                }
                int ty = y;
                if ((align & 6) == 2) {
                    ty -= height - dx[dx.length - 1];
                } else if ((align & 6) == 6) {
                    ty -= (height - dx[dx.length - 1]) / 2;
                }
                for (int i = 0; i < dx.length; ++i) {
                    this.buffer.append(" ");
                    this.buffer.append((int)this.dc.toAbsoluteY(ty));
                    ty += dx[i];
                }
                if ((align & 1) == 1) {
                    this.dc.moveToEx(x, ty, null);
                }
            } else if (this.dc.getFont() != null) {
                height = Math.abs(this.dc.getFont().getFontSize() * text.length) / 2;
            }
            elem.setAttribute("y", this.buffer.toString());
        } else {
            if (this.dc.getFont() != null) {
                height = Math.abs(this.dc.getFont().getFontSize());
            }
            if (this.compatible) {
                if ((align & 0x18) == 0) {
                    elem.setAttribute("y", Integer.toString(ay + (int)this.dc.toRelativeY((double)height * 0.88)));
                } else if ((align & 0x18) == 8) {
                    elem.setAttribute("y", Integer.toString(ay + rect[3] - rect[1] + (int)this.dc.toRelativeY((double)height * 0.88)));
                } else {
                    elem.setAttribute("y", Integer.toString(ay));
                }
            } else if ((align & 0x18) == 8 && rect != null) {
                elem.setAttribute("y", Integer.toString(ay + rect[3] - rect[1] - (int)this.dc.toRelativeY(height)));
            } else {
                elem.setAttribute("y", Integer.toString(ay));
            }
        }
        Element bk = null;
        if (this.dc.getBkMode() == 2 || (options & 2) > 0) {
            if (rect == null && this.dc.getFont() != null) {
                rect = new int[4];
                if (vertical) {
                    rect[0] = (align & 0x18) == 8 ? x - width : ((align & 0x18) == 24 ? x - (int)((double)width * 0.85) : x);
                    rect[1] = (align & 6) == 2 ? y - height : ((align & 6) == 6 ? y - height / 2 : y);
                } else {
                    rect[0] = (align & 6) == 2 ? x - width : ((align & 6) == 6 ? x - width / 2 : x);
                    rect[1] = (align & 0x18) == 8 ? y - height : ((align & 0x18) == 24 ? y - (int)((double)height * 0.85) : y);
                }
                rect[2] = rect[0] + width;
                rect[3] = rect[1] + height;
            }
            bk = this.doc.createElement("rect");
            bk.setAttribute("x", Integer.toString((int)this.dc.toAbsoluteX(rect[0])));
            bk.setAttribute("y", Integer.toString((int)this.dc.toAbsoluteY(rect[1])));
            bk.setAttribute("width", Integer.toString((int)this.dc.toRelativeX(rect[2] - rect[0])));
            bk.setAttribute("height", Integer.toString((int)this.dc.toRelativeY(rect[3] - rect[1])));
            bk.setAttribute("fill", SvgObject.toColor(this.dc.getBkColor()));
        }
        Element clip = null;
        if ((options & 4) > 0) {
            String name = "clipPath" + this.clipPathNo++;
            clip = this.doc.createElement("clipPath");
            clip.setAttribute("id", name);
            clip.setIdAttribute("id", true);
            Element clipRect = this.doc.createElement("rect");
            clipRect.setAttribute("x", Integer.toString((int)this.dc.toAbsoluteX(rect[0])));
            clipRect.setAttribute("y", Integer.toString((int)this.dc.toAbsoluteY(rect[1])));
            clipRect.setAttribute("width", Integer.toString((int)this.dc.toRelativeX(rect[2] - rect[0])));
            clipRect.setAttribute("height", Integer.toString((int)this.dc.toRelativeY(rect[3] - rect[1])));
            clip.appendChild(clipRect);
            elem.setAttribute("clip-path", "url(#" + name + ")");
        }
        String str = null;
        str = this.dc.getFont() != null ? GdiUtils.convertString(text, this.dc.getFont().getCharset()) : GdiUtils.convertString(text, 1);
        if (this.dc.getFont() != null && this.dc.getFont().getLang() != null) {
            elem.setAttribute("xml:lang", this.dc.getFont().getLang());
        }
        elem.setAttribute("xml:space", "preserve");
        this.appendText(elem, str);
        if (bk != null || clip != null) {
            Element g = this.doc.createElement("g");
            if (bk != null) {
                g.appendChild(bk);
            }
            if (clip != null) {
                g.appendChild(clip);
            }
            g.appendChild(elem);
            elem = g;
        }
        if (escapement != 0) {
            elem.setAttribute("transform", "rotate(" + (double)(-escapement) / 10.0 + ", " + ax + ", " + ay + ")");
        }
        this.parentNode.appendChild(elem);
    }

    @Override
    public void fillRgn(GdiRegion rgn, GdiBrush brush) {
        if (rgn == null) {
            return;
        }
        Element elem = this.doc.createElement("use");
        elem.setAttribute("xlink:href", "url(#" + this.nameMap.get(rgn) + ")");
        elem.setAttribute("class", this.getClassString(brush));
        SvgBrush sbrush = (SvgBrush)brush;
        if (sbrush.getStyle() == 2) {
            String id = "pattern" + this.patternNo++;
            elem.setAttribute("fill", "url(#" + id + ")");
            this.defsNode.appendChild(sbrush.createFillPattern(id));
        }
        this.parentNode.appendChild(elem);
    }

    @Override
    public void floodFill(int x, int y, int color) {
        log.fine("not implemented: floodFill");
    }

    @Override
    public void frameRgn(GdiRegion rgn, GdiBrush brush, int width, int height) {
        log.fine("not implemented: frameRgn");
    }

    @Override
    public void intersectClipRect(int left, int top, int right, int bottom) {
        log.fine("not implemented: intersectClipRect");
    }

    @Override
    public void invertRgn(GdiRegion rgn) {
        if (rgn == null) {
            return;
        }
        Element elem = this.doc.createElement("use");
        elem.setAttribute("xlink:href", "url(#" + this.nameMap.get(rgn) + ")");
        String ropFilter = this.dc.getRopFilter(0x550009L);
        if (ropFilter != null) {
            elem.setAttribute("filter", ropFilter);
        }
        this.parentNode.appendChild(elem);
    }

    @Override
    public void lineTo(int ex, int ey) {
        Element elem = this.doc.createElement("line");
        if (this.dc.getPen() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        elem.setAttribute("fill", "none");
        elem.setAttribute("x1", "" + (int)this.dc.toAbsoluteX(this.dc.getCurrentX()));
        elem.setAttribute("y1", "" + (int)this.dc.toAbsoluteY(this.dc.getCurrentY()));
        elem.setAttribute("x2", "" + (int)this.dc.toAbsoluteX(ex));
        elem.setAttribute("y2", "" + (int)this.dc.toAbsoluteY(ey));
        this.parentNode.appendChild(elem);
        this.dc.moveToEx(ex, ey, null);
    }

    @Override
    public void moveToEx(int x, int y, Point old) {
        this.dc.moveToEx(x, y, old);
    }

    @Override
    public void offsetClipRgn(int x, int y) {
        this.dc.offsetClipRgn(x, y);
        Element mask = this.dc.getMask();
        if (mask != null) {
            mask = (Element)mask.cloneNode(true);
            String name = "mask" + this.maskNo++;
            mask.setAttribute("id", name);
            if (this.dc.getOffsetClipX() != 0 || this.dc.getOffsetClipY() != 0) {
                mask.setAttribute("transform", "translate(" + this.dc.getOffsetClipX() + "," + this.dc.getOffsetClipY() + ")");
            }
            this.defsNode.appendChild(mask);
            if (!this.parentNode.hasChildNodes()) {
                this.doc.getDocumentElement().removeChild(this.parentNode);
            }
            this.parentNode = this.doc.createElement("g");
            this.parentNode.setAttribute("mask", name);
            this.doc.getDocumentElement().appendChild(this.parentNode);
            this.dc.setMask(mask);
        }
    }

    @Override
    public void offsetViewportOrgEx(int x, int y, Point point) {
        this.dc.offsetViewportOrgEx(x, y, point);
    }

    @Override
    public void offsetWindowOrgEx(int x, int y, Point point) {
        this.dc.offsetWindowOrgEx(x, y, point);
    }

    @Override
    public void paintRgn(GdiRegion rgn) {
        this.fillRgn(rgn, this.dc.getBrush());
    }

    @Override
    public void patBlt(int x, int y, int width, int height, long rop) {
        log.fine("not implemented: patBlt");
    }

    @Override
    public void pie(int sxr, int syr, int exr, int eyr, int sxa, int sya, int exa, int eya) {
        double rx = (double)Math.abs(exr - sxr) / 2.0;
        double ry = (double)Math.abs(eyr - syr) / 2.0;
        if (rx <= 0.0 || ry <= 0.0) {
            return;
        }
        double cx = (double)Math.min(sxr, exr) + rx;
        double cy = (double)Math.min(syr, eyr) + ry;
        Element elem = null;
        if (sxa == exa && sya == eya) {
            if (rx == ry) {
                elem = this.doc.createElement("circle");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("r", "" + this.dc.toRelativeX(rx));
            } else {
                elem = this.doc.createElement("ellipse");
                elem.setAttribute("cx", "" + this.dc.toAbsoluteX(cx));
                elem.setAttribute("cy", "" + this.dc.toAbsoluteY(cy));
                elem.setAttribute("rx", "" + this.dc.toRelativeX(rx));
                elem.setAttribute("ry", "" + this.dc.toRelativeY(ry));
            }
        } else {
            double sa = Math.atan2(((double)sya - cy) * rx, ((double)sxa - cx) * ry);
            double sx = rx * Math.cos(sa);
            double sy = ry * Math.sin(sa);
            double ea = Math.atan2(((double)eya - cy) * rx, ((double)exa - cx) * ry);
            double ex = rx * Math.cos(ea);
            double ey = ry * Math.sin(ea);
            double a = Math.atan2((ex - sx) * -sy - (ey - sy) * -sx, (ex - sx) * -sx + (ey - sy) * -sy);
            elem = this.doc.createElement("path");
            elem.setAttribute("d", "M " + this.dc.toAbsoluteX(cx) + "," + this.dc.toAbsoluteY(cy) + " L " + this.dc.toAbsoluteX(sx + cx) + "," + this.dc.toAbsoluteY(sy + cy) + " A " + this.dc.toRelativeX(rx) + "," + this.dc.toRelativeY(ry) + " 0 " + (a > 0.0 ? "1" : "0") + " 0 " + this.dc.toAbsoluteX(ex + cx) + "," + this.dc.toAbsoluteY(ey + cy) + " Z");
        }
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
        }
        this.parentNode.appendChild(elem);
    }

    @Override
    public void polygon(Point[] points) {
        Element elem = this.doc.createElement("polygon");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
            if (this.dc.getPolyFillMode() == 2) {
                elem.setAttribute("fill-rule", "nonzero");
            }
        }
        this.buffer.setLength(0);
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            this.buffer.append((int)this.dc.toAbsoluteX(points[i].x)).append(",");
            this.buffer.append((int)this.dc.toAbsoluteY(points[i].y));
        }
        elem.setAttribute("points", this.buffer.toString());
        this.parentNode.appendChild(elem);
    }

    @Override
    public void polyline(Point[] points) {
        Element elem = this.doc.createElement("polyline");
        if (this.dc.getPen() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen()));
        }
        elem.setAttribute("fill", "none");
        this.buffer.setLength(0);
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            this.buffer.append((int)this.dc.toAbsoluteX(points[i].x)).append(",");
            this.buffer.append((int)this.dc.toAbsoluteY(points[i].y));
        }
        elem.setAttribute("points", this.buffer.toString());
        this.parentNode.appendChild(elem);
    }

    @Override
    public void polyPolygon(Point[][] points) {
        Element elem = this.doc.createElement("path");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
            if (this.dc.getPolyFillMode() == 2) {
                elem.setAttribute("fill-rule", "nonzero");
            }
        }
        this.buffer.setLength(0);
        for (int i = 0; i < points.length; ++i) {
            if (i != 0) {
                this.buffer.append(" ");
            }
            for (int j = 0; j < points[i].length; ++j) {
                if (j == 0) {
                    this.buffer.append("M ");
                } else if (j == 1) {
                    this.buffer.append(" L ");
                }
                this.buffer.append((int)this.dc.toAbsoluteX(points[i][j].x)).append(",");
                this.buffer.append((int)this.dc.toAbsoluteY(points[i][j].y)).append(" ");
                if (j != points[i].length - 1) continue;
                this.buffer.append("z");
            }
        }
        elem.setAttribute("d", this.buffer.toString());
        this.parentNode.appendChild(elem);
    }

    @Override
    public void realizePalette() {
        log.fine("not implemented: realizePalette");
    }

    @Override
    public void restoreDC(int savedDC) {
        int limit = savedDC < 0 ? -savedDC : this.saveDC.size() - savedDC;
        for (int i = 0; i < limit; ++i) {
            this.dc = this.saveDC.removeLast();
        }
        if (!this.parentNode.hasChildNodes()) {
            this.doc.getDocumentElement().removeChild(this.parentNode);
        }
        this.parentNode = this.doc.createElement("g");
        Element mask = this.dc.getMask();
        if (mask != null) {
            this.parentNode.setAttribute("mask", "url(#" + mask.getAttribute("id") + ")");
        }
        this.doc.getDocumentElement().appendChild(this.parentNode);
    }

    @Override
    public void rectangle(int sx, int sy, int ex, int ey) {
        Element elem = this.doc.createElement("rect");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
        }
        elem.setAttribute("x", "" + (int)this.dc.toAbsoluteX(sx));
        elem.setAttribute("y", "" + (int)this.dc.toAbsoluteY(sy));
        elem.setAttribute("width", "" + (int)this.dc.toRelativeX(ex - sx));
        elem.setAttribute("height", "" + (int)this.dc.toRelativeY(ey - sy));
        this.parentNode.appendChild(elem);
    }

    @Override
    public void resizePalette(GdiPalette palette) {
        log.fine("not implemented: ResizePalette");
    }

    @Override
    public void roundRect(int sx, int sy, int ex, int ey, int rw, int rh) {
        Element elem = this.doc.createElement("rect");
        if (this.dc.getPen() != null || this.dc.getBrush() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getPen(), this.dc.getBrush()));
            if (this.dc.getBrush() != null && this.dc.getBrush().getStyle() == 2) {
                String id = "pattern" + this.patternNo++;
                elem.setAttribute("fill", "url(#" + id + ")");
                this.defsNode.appendChild(this.dc.getBrush().createFillPattern(id));
            }
        }
        elem.setAttribute("x", "" + (int)this.dc.toAbsoluteX(sx));
        elem.setAttribute("y", "" + (int)this.dc.toAbsoluteY(sy));
        elem.setAttribute("width", "" + (int)this.dc.toRelativeX(ex - sx));
        elem.setAttribute("height", "" + (int)this.dc.toRelativeY(ey - sy));
        elem.setAttribute("rx", "" + (int)this.dc.toRelativeX(rw));
        elem.setAttribute("ry", "" + (int)this.dc.toRelativeY(rh));
        this.parentNode.appendChild(elem);
    }

    @Override
    public void seveDC() {
        this.saveDC.add((SvgDc)this.dc.clone());
    }

    @Override
    public void scaleViewportExtEx(int x, int xd, int y, int yd, Size old) {
        this.dc.scaleViewportExtEx(x, xd, y, yd, old);
    }

    @Override
    public void scaleWindowExtEx(int x, int xd, int y, int yd, Size old) {
        this.dc.scaleWindowExtEx(x, xd, y, yd, old);
    }

    @Override
    public void selectClipRgn(GdiRegion rgn) {
        if (!this.parentNode.hasChildNodes()) {
            this.doc.getDocumentElement().removeChild(this.parentNode);
        }
        this.parentNode = this.doc.createElement("g");
        if (rgn != null) {
            Element mask = this.doc.createElement("mask");
            mask.setAttribute("id", "mask" + this.maskNo++);
            mask.setIdAttribute("id", true);
            if (this.dc.getOffsetClipX() != 0 || this.dc.getOffsetClipY() != 0) {
                mask.setAttribute("transform", "translate(" + this.dc.getOffsetClipX() + "," + this.dc.getOffsetClipY() + ")");
            }
            this.defsNode.appendChild(mask);
            Element clip = this.doc.createElement("use");
            clip.setAttribute("xlink:href", "url(#" + this.nameMap.get(rgn) + ")");
            clip.setAttribute("fill", "white");
            mask.appendChild(clip);
            this.parentNode.setAttribute("mask", "url(#" + mask.getAttribute("id") + ")");
        }
        this.doc.getDocumentElement().appendChild(this.parentNode);
    }

    @Override
    public void selectObject(GdiObject obj) {
        if (obj instanceof SvgBrush) {
            this.dc.setBrush((SvgBrush)obj);
        } else if (obj instanceof SvgFont) {
            this.dc.setFont((SvgFont)obj);
        } else if (obj instanceof SvgPen) {
            this.dc.setPen((SvgPen)obj);
        }
    }

    @Override
    public void selectPalette(GdiPalette palette, boolean mode) {
        log.fine("not implemented: selectPalette");
    }

    @Override
    public void setBkColor(int color) {
        this.dc.setBkColor(color);
    }

    @Override
    public void setBkMode(int mode) {
        this.dc.setBkMode(mode);
    }

    @Override
    public void setDIBitsToDevice(int dx, int dy, int dw, int dh, int sx, int sy, int startscan, int scanlines, byte[] image, int colorUse) {
        this.stretchDIBits(dx, dy, dw, dh, sx, sy, dw, dh, image, colorUse, 0xCC0020L);
    }

    @Override
    public void setLayout(long layout) {
        this.dc.setLayout(layout);
    }

    @Override
    public void setMapMode(int mode) {
        this.dc.setMapMode(mode);
    }

    @Override
    public void setMapperFlags(long flags) {
        this.dc.setMapperFlags(flags);
    }

    @Override
    public void setPaletteEntries(GdiPalette palette, int startIndex, int[] entries) {
        log.fine("not implemented: setPaletteEntries");
    }

    @Override
    public void setPixel(int x, int y, int color) {
        Element elem = this.doc.createElement("rect");
        elem.setAttribute("stroke", "none");
        elem.setAttribute("fill", SvgPen.toColor(color));
        elem.setAttribute("x", "" + (int)this.dc.toAbsoluteX(x));
        elem.setAttribute("y", "" + (int)this.dc.toAbsoluteY(y));
        elem.setAttribute("width", "" + (int)this.dc.toRelativeX(1.0));
        elem.setAttribute("height", "" + (int)this.dc.toRelativeY(1.0));
        this.parentNode.appendChild(elem);
    }

    @Override
    public void setPolyFillMode(int mode) {
        this.dc.setPolyFillMode(mode);
    }

    @Override
    public void setRelAbs(int mode) {
        this.dc.setRelAbs(mode);
    }

    @Override
    public void setROP2(int mode) {
        this.dc.setROP2(mode);
    }

    @Override
    public void setStretchBltMode(int mode) {
        this.dc.setStretchBltMode(mode);
    }

    @Override
    public void setTextAlign(int align) {
        this.dc.setTextAlign(align);
    }

    @Override
    public void setTextCharacterExtra(int extra) {
        this.dc.setTextCharacterExtra(extra);
    }

    @Override
    public void setTextColor(int color) {
        this.dc.setTextColor(color);
    }

    @Override
    public void setTextJustification(int breakExtra, int breakCount) {
        if (breakCount > 0) {
            this.dc.setTextSpace(Math.abs((int)this.dc.toRelativeX(breakExtra)) / breakCount);
        }
    }

    @Override
    public void setViewportExtEx(int x, int y, Size old) {
        this.dc.setViewportExtEx(x, y, old);
    }

    @Override
    public void setViewportOrgEx(int x, int y, Point old) {
        this.dc.setViewportOrgEx(x, y, old);
    }

    @Override
    public void setWindowExtEx(int width, int height, Size old) {
        this.dc.setWindowExtEx(width, height, old);
    }

    @Override
    public void setWindowOrgEx(int x, int y, Point old) {
        this.dc.setWindowOrgEx(x, y, old);
    }

    @Override
    public void stretchBlt(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, long rop) {
        this.dibStretchBlt(image, dx, dy, dw, dh, sx, sy, sw, sh, rop);
    }

    @Override
    public void stretchDIBits(int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, byte[] image, int usage, long rop) {
        this.bmpToSvg(image, dx, dy, dw, dh, sx, sy, sw, sh, usage, rop);
    }

    @Override
    public void textOut(int x, int y, byte[] text) {
        Element elem = this.doc.createElement("text");
        int escapement = 0;
        boolean vertical = false;
        if (this.dc.getFont() != null) {
            elem.setAttribute("class", this.getClassString(this.dc.getFont()));
            if (this.dc.getFont().getFaceName().startsWith("@")) {
                vertical = true;
                escapement = this.dc.getFont().getEscapement() - 2700;
            } else {
                escapement = this.dc.getFont().getEscapement();
            }
        }
        elem.setAttribute("fill", SvgObject.toColor(this.dc.getTextColor()));
        this.buffer.setLength(0);
        int align = this.dc.getTextAlign();
        if ((align & 6) == 2) {
            this.buffer.append("text-anchor: end; ");
        } else if ((align & 6) == 6) {
            this.buffer.append("text-anchor: middle; ");
        }
        if (vertical) {
            elem.setAttribute("writing-mode", "tb");
            this.buffer.append("dominant-baseline: ideographic; ");
        } else if ((align & 0x18) == 24) {
            this.buffer.append("dominant-baseline: alphabetic; ");
        } else {
            this.buffer.append("dominant-baseline: text-before-edge; ");
        }
        if ((align & 0x100) == 256) {
            this.buffer.append("unicode-bidi: bidi-override; direction: rtl; ");
        }
        if (this.dc.getTextSpace() > 0) {
            this.buffer.append("word-spacing: " + this.dc.getTextSpace() + "; ");
        }
        if (this.buffer.length() > 0) {
            this.buffer.setLength(this.buffer.length() - 1);
            elem.setAttribute("style", this.buffer.toString());
        }
        elem.setAttribute("stroke", "none");
        int ax = (int)this.dc.toAbsoluteX(x);
        int ay = (int)this.dc.toAbsoluteY(y);
        elem.setAttribute("x", Integer.toString(ax));
        elem.setAttribute("y", Integer.toString(ay));
        if (escapement != 0) {
            elem.setAttribute("transform", "rotate(" + (double)(-escapement) / 10.0 + ", " + ax + ", " + ay + ")");
        }
        String str = null;
        str = this.dc.getFont() != null ? GdiUtils.convertString(text, this.dc.getFont().getCharset()) : GdiUtils.convertString(text, 1);
        if (this.dc.getTextCharacterExtra() != 0) {
            this.buffer.setLength(0);
            for (int i = 0; i < str.length() - 1; ++i) {
                if (i != 0) {
                    this.buffer.append(" ");
                }
                this.buffer.append((int)this.dc.toRelativeX(this.dc.getTextCharacterExtra()));
            }
            elem.setAttribute("dx", this.buffer.toString());
        }
        if (this.dc.getFont() != null && this.dc.getFont().getLang() != null) {
            elem.setAttribute("xml:lang", this.dc.getFont().getLang());
        }
        elem.setAttribute("xml:space", "preserve");
        this.appendText(elem, str);
        this.parentNode.appendChild(elem);
    }

    @Override
    public void footer() {
        Element root = this.doc.getDocumentElement();
        if (!root.hasAttribute("width") && this.dc.getWindowWidth() != 0) {
            root.setAttribute("width", "" + Math.abs(this.dc.getWindowWidth()));
        }
        if (!root.hasAttribute("height") && this.dc.getWindowHeight() != 0) {
            root.setAttribute("height", "" + Math.abs(this.dc.getWindowHeight()));
        }
        if (this.dc.getWindowWidth() != 0 && this.dc.getWindowHeight() != 0) {
            root.setAttribute("viewBox", "0 0 " + Math.abs(this.dc.getWindowWidth()) + " " + Math.abs(this.dc.getWindowHeight()));
            root.setAttribute("preserveAspectRatio", "none");
        }
        root.setAttribute("stroke-linecap", "round");
        root.setAttribute("fill-rule", "evenodd");
        if (!this.styleNode.hasChildNodes()) {
            root.removeChild(this.styleNode);
        } else {
            this.styleNode.insertBefore(this.doc.createTextNode("\n"), this.styleNode.getFirstChild());
        }
        if (!this.defsNode.hasChildNodes()) {
            root.removeChild(this.defsNode);
        }
    }

    private String getClassString(GdiObject obj1, GdiObject obj2) {
        String name1 = this.getClassString(obj1);
        String name2 = this.getClassString(obj2);
        if (name1 != null && name2 != null) {
            return name1 + " " + name2;
        }
        if (name1 != null) {
            return name1;
        }
        if (name2 != null) {
            return name2;
        }
        return "";
    }

    private String getClassString(GdiObject style) {
        if (style == null) {
            return "";
        }
        return this.nameMap.get(style);
    }

    private void appendText(Element elem, String str) {
        if (this.compatible) {
            str = str.replaceAll("\\r\\n|[\\t\\r\\n ]", "\u00a0");
        }
        SvgFont font = this.dc.getFont();
        if (this.replaceSymbolFont && font != null && "Symbol".equals(font.getFaceName())) {
            int state = 0;
            int start = 0;
            char[] ca = str.toCharArray();
            for (int i = 0; i < ca.length; ++i) {
                int nstate = state;
                switch (ca[i]) {
                    case '\"': {
                        ca[i] = 8704;
                        nstate = 1;
                        break;
                    }
                    case '$': {
                        ca[i] = 8707;
                        nstate = 1;
                        break;
                    }
                    case '\'': {
                        ca[i] = 8717;
                        nstate = 1;
                        break;
                    }
                    case '*': {
                        ca[i] = 8727;
                        nstate = 1;
                        break;
                    }
                    case '-': {
                        ca[i] = 8722;
                        nstate = 1;
                        break;
                    }
                    case '@': {
                        ca[i] = 8773;
                        nstate = 1;
                        break;
                    }
                    case 'A': {
                        ca[i] = 913;
                        nstate = 1;
                        break;
                    }
                    case 'B': {
                        ca[i] = 914;
                        nstate = 1;
                        break;
                    }
                    case 'C': {
                        ca[i] = 935;
                        nstate = 1;
                        break;
                    }
                    case 'D': {
                        ca[i] = 916;
                        nstate = 1;
                        break;
                    }
                    case 'E': {
                        ca[i] = 917;
                        nstate = 1;
                        break;
                    }
                    case 'F': {
                        ca[i] = 934;
                        nstate = 1;
                        break;
                    }
                    case 'G': {
                        ca[i] = 915;
                        nstate = 1;
                        break;
                    }
                    case 'H': {
                        ca[i] = 919;
                        nstate = 1;
                        break;
                    }
                    case 'I': {
                        ca[i] = 921;
                        nstate = 1;
                        break;
                    }
                    case 'J': {
                        ca[i] = 977;
                        nstate = 1;
                        break;
                    }
                    case 'K': {
                        ca[i] = 922;
                        nstate = 1;
                        break;
                    }
                    case 'L': {
                        ca[i] = 923;
                        nstate = 1;
                        break;
                    }
                    case 'M': {
                        ca[i] = 924;
                        nstate = 1;
                        break;
                    }
                    case 'N': {
                        ca[i] = 925;
                        nstate = 1;
                        break;
                    }
                    case 'O': {
                        ca[i] = 927;
                        nstate = 1;
                        break;
                    }
                    case 'P': {
                        ca[i] = 928;
                        nstate = 1;
                        break;
                    }
                    case 'Q': {
                        ca[i] = 920;
                        nstate = 1;
                        break;
                    }
                    case 'R': {
                        ca[i] = 929;
                        nstate = 1;
                        break;
                    }
                    case 'S': {
                        ca[i] = 931;
                        nstate = 1;
                        break;
                    }
                    case 'T': {
                        ca[i] = 932;
                        nstate = 1;
                        break;
                    }
                    case 'U': {
                        ca[i] = 933;
                        nstate = 1;
                        break;
                    }
                    case 'V': {
                        ca[i] = 963;
                        nstate = 1;
                        break;
                    }
                    case 'W': {
                        ca[i] = 937;
                        nstate = 1;
                        break;
                    }
                    case 'X': {
                        ca[i] = 926;
                        nstate = 1;
                        break;
                    }
                    case 'Y': {
                        ca[i] = 936;
                        nstate = 1;
                        break;
                    }
                    case 'Z': {
                        ca[i] = 918;
                        nstate = 1;
                        break;
                    }
                    case '\\': {
                        ca[i] = 8756;
                        nstate = 1;
                        break;
                    }
                    case '^': {
                        ca[i] = 8869;
                        nstate = 1;
                        break;
                    }
                    case '`': {
                        ca[i] = 63717;
                        nstate = 1;
                        break;
                    }
                    case 'a': {
                        ca[i] = 945;
                        nstate = 1;
                        break;
                    }
                    case 'b': {
                        ca[i] = 946;
                        nstate = 1;
                        break;
                    }
                    case 'c': {
                        ca[i] = 967;
                        nstate = 1;
                        break;
                    }
                    case 'd': {
                        ca[i] = 948;
                        nstate = 1;
                        break;
                    }
                    case 'e': {
                        ca[i] = 949;
                        nstate = 1;
                        break;
                    }
                    case 'f': {
                        ca[i] = 966;
                        nstate = 1;
                        break;
                    }
                    case 'g': {
                        ca[i] = 947;
                        nstate = 1;
                        break;
                    }
                    case 'h': {
                        ca[i] = 951;
                        nstate = 1;
                        break;
                    }
                    case 'i': {
                        ca[i] = 953;
                        nstate = 1;
                        break;
                    }
                    case 'j': {
                        ca[i] = 981;
                        nstate = 1;
                        break;
                    }
                    case 'k': {
                        ca[i] = 954;
                        nstate = 1;
                        break;
                    }
                    case 'l': {
                        ca[i] = 955;
                        nstate = 1;
                        break;
                    }
                    case 'm': {
                        ca[i] = 956;
                        nstate = 1;
                        break;
                    }
                    case 'n': {
                        ca[i] = 957;
                        nstate = 1;
                        break;
                    }
                    case 'o': {
                        ca[i] = 959;
                        nstate = 1;
                        break;
                    }
                    case 'p': {
                        ca[i] = 960;
                        nstate = 1;
                        break;
                    }
                    case 'q': {
                        ca[i] = 952;
                        nstate = 1;
                        break;
                    }
                    case 'r': {
                        ca[i] = 961;
                        nstate = 1;
                        break;
                    }
                    case 's': {
                        ca[i] = 963;
                        nstate = 1;
                        break;
                    }
                    case 't': {
                        ca[i] = 964;
                        nstate = 1;
                        break;
                    }
                    case 'u': {
                        ca[i] = 965;
                        nstate = 1;
                        break;
                    }
                    case 'v': {
                        ca[i] = 982;
                        nstate = 1;
                        break;
                    }
                    case 'w': {
                        ca[i] = 969;
                        nstate = 1;
                        break;
                    }
                    case 'x': {
                        ca[i] = 958;
                        nstate = 1;
                        break;
                    }
                    case 'y': {
                        ca[i] = 968;
                        nstate = 1;
                        break;
                    }
                    case 'z': {
                        ca[i] = 950;
                        nstate = 1;
                        break;
                    }
                    case '~': {
                        ca[i] = 8764;
                        nstate = 1;
                        break;
                    }
                    case '\u00a0': {
                        ca[i] = 8364;
                        nstate = 1;
                        break;
                    }
                    case '\u00a1': {
                        ca[i] = 978;
                        nstate = 1;
                        break;
                    }
                    case '\u00a2': {
                        ca[i] = 8242;
                        nstate = 1;
                        break;
                    }
                    case '\u00a3': {
                        ca[i] = 8804;
                        nstate = 1;
                        break;
                    }
                    case '\u00a4': {
                        ca[i] = 8260;
                        nstate = 1;
                        break;
                    }
                    case '\u00a5': {
                        ca[i] = 8734;
                        nstate = 1;
                        break;
                    }
                    case '\u00a6': {
                        ca[i] = 402;
                        nstate = 1;
                        break;
                    }
                    case '\u00a7': {
                        ca[i] = 9827;
                        nstate = 1;
                        break;
                    }
                    case '\u00a8': {
                        ca[i] = 9830;
                        nstate = 1;
                        break;
                    }
                    case '\u00a9': {
                        ca[i] = 9829;
                        nstate = 1;
                        break;
                    }
                    case '\u00aa': {
                        ca[i] = 9824;
                        nstate = 1;
                        break;
                    }
                    case '\u00ab': {
                        ca[i] = 8596;
                        nstate = 1;
                        break;
                    }
                    case '\u00ac': {
                        ca[i] = 8592;
                        nstate = 1;
                        break;
                    }
                    case '\u00ad': {
                        ca[i] = 8593;
                        nstate = 1;
                        break;
                    }
                    case '\u00ae': {
                        ca[i] = 8594;
                        nstate = 1;
                        break;
                    }
                    case '\u00af': {
                        ca[i] = 8595;
                        nstate = 1;
                        break;
                    }
                    case '\u00b2': {
                        ca[i] = 8243;
                        nstate = 1;
                        break;
                    }
                    case '\u00b3': {
                        ca[i] = 8805;
                        nstate = 1;
                        break;
                    }
                    case '\u00b4': {
                        ca[i] = 215;
                        nstate = 1;
                        break;
                    }
                    case '\u00b5': {
                        ca[i] = 8733;
                        nstate = 1;
                        break;
                    }
                    case '\u00b6': {
                        ca[i] = 8706;
                        nstate = 1;
                        break;
                    }
                    case '\u00b7': {
                        ca[i] = 8226;
                        nstate = 1;
                        break;
                    }
                    case '\u00b8': {
                        ca[i] = 247;
                        nstate = 1;
                        break;
                    }
                    case '\u00b9': {
                        ca[i] = 8800;
                        nstate = 1;
                        break;
                    }
                    case '\u00ba': {
                        ca[i] = 8801;
                        nstate = 1;
                        break;
                    }
                    case '\u00bb': {
                        ca[i] = 8776;
                        nstate = 1;
                        break;
                    }
                    case '\u00bc': {
                        ca[i] = 8230;
                        nstate = 1;
                        break;
                    }
                    case '\u00bd': {
                        ca[i] = 9168;
                        nstate = 1;
                        break;
                    }
                    case '\u00be': {
                        ca[i] = 9135;
                        nstate = 1;
                        break;
                    }
                    case '\u00bf': {
                        ca[i] = 8629;
                        nstate = 1;
                        break;
                    }
                    case '\u00c0': {
                        ca[i] = 8501;
                        nstate = 1;
                        break;
                    }
                    case '\u00c1': {
                        ca[i] = 8465;
                        nstate = 1;
                        break;
                    }
                    case '\u00c2': {
                        ca[i] = 8476;
                        nstate = 1;
                        break;
                    }
                    case '\u00c3': {
                        ca[i] = 8472;
                        nstate = 1;
                        break;
                    }
                    case '\u00c4': {
                        ca[i] = 8855;
                        nstate = 1;
                        break;
                    }
                    case '\u00c5': {
                        ca[i] = 8853;
                        nstate = 1;
                        break;
                    }
                    case '\u00c6': {
                        ca[i] = 8709;
                        nstate = 1;
                        break;
                    }
                    case '\u00c7': {
                        ca[i] = 8745;
                        nstate = 1;
                        break;
                    }
                    case '\u00c8': {
                        ca[i] = 8746;
                        nstate = 1;
                        break;
                    }
                    case '\u00c9': {
                        ca[i] = 8835;
                        nstate = 1;
                        break;
                    }
                    case '\u00ca': {
                        ca[i] = 8839;
                        nstate = 1;
                        break;
                    }
                    case '\u00cb': {
                        ca[i] = 8836;
                        nstate = 1;
                        break;
                    }
                    case '\u00cc': {
                        ca[i] = 8834;
                        nstate = 1;
                        break;
                    }
                    case '\u00cd': {
                        ca[i] = 8838;
                        nstate = 1;
                        break;
                    }
                    case '\u00ce': {
                        ca[i] = 8712;
                        nstate = 1;
                        break;
                    }
                    case '\u00cf': {
                        ca[i] = 8713;
                        nstate = 1;
                        break;
                    }
                    case '\u00d0': {
                        ca[i] = 8736;
                        nstate = 1;
                        break;
                    }
                    case '\u00d1': {
                        ca[i] = 8711;
                        nstate = 1;
                        break;
                    }
                    case '\u00d2': {
                        ca[i] = 174;
                        nstate = 1;
                        break;
                    }
                    case '\u00d3': {
                        ca[i] = 169;
                        nstate = 1;
                        break;
                    }
                    case '\u00d4': {
                        ca[i] = 8482;
                        nstate = 1;
                        break;
                    }
                    case '\u00d5': {
                        ca[i] = 8719;
                        nstate = 1;
                        break;
                    }
                    case '\u00d6': {
                        ca[i] = 8730;
                        nstate = 1;
                        break;
                    }
                    case '\u00d7': {
                        ca[i] = 8901;
                        nstate = 1;
                        break;
                    }
                    case '\u00d8': {
                        ca[i] = 172;
                        nstate = 1;
                        break;
                    }
                    case '\u00d9': {
                        ca[i] = 8743;
                        nstate = 1;
                        break;
                    }
                    case '\u00da': {
                        ca[i] = 8744;
                        nstate = 1;
                        break;
                    }
                    case '\u00db': {
                        ca[i] = 8660;
                        nstate = 1;
                        break;
                    }
                    case '\u00dc': {
                        ca[i] = 8656;
                        nstate = 1;
                        break;
                    }
                    case '\u00dd': {
                        ca[i] = 8657;
                        nstate = 1;
                        break;
                    }
                    case '\u00de': {
                        ca[i] = 8658;
                        nstate = 1;
                        break;
                    }
                    case '\u00df': {
                        ca[i] = 8659;
                        nstate = 1;
                        break;
                    }
                    case '\u00e0': {
                        ca[i] = 9674;
                        nstate = 1;
                        break;
                    }
                    case '\u00e1': {
                        ca[i] = 12296;
                        nstate = 1;
                        break;
                    }
                    case '\u00e2': {
                        ca[i] = 174;
                        nstate = 2;
                        break;
                    }
                    case '\u00e3': {
                        ca[i] = 169;
                        nstate = 2;
                        break;
                    }
                    case '\u00e4': {
                        ca[i] = 8482;
                        nstate = 2;
                        break;
                    }
                    case '\u00e5': {
                        ca[i] = 8721;
                        nstate = 1;
                        break;
                    }
                    case '\u00e6': {
                        ca[i] = 9115;
                        nstate = 1;
                        break;
                    }
                    case '\u00e7': {
                        ca[i] = 9116;
                        nstate = 1;
                        break;
                    }
                    case '\u00e8': {
                        ca[i] = 9117;
                        nstate = 1;
                        break;
                    }
                    case '\u00e9': {
                        ca[i] = 9121;
                        nstate = 1;
                        break;
                    }
                    case '\u00ea': {
                        ca[i] = 9122;
                        nstate = 1;
                        break;
                    }
                    case '\u00eb': {
                        ca[i] = 9123;
                        nstate = 1;
                        break;
                    }
                    case '\u00ec': {
                        ca[i] = 9127;
                        nstate = 1;
                        break;
                    }
                    case '\u00ed': {
                        ca[i] = 9128;
                        nstate = 1;
                        break;
                    }
                    case '\u00ee': {
                        ca[i] = 9129;
                        nstate = 1;
                        break;
                    }
                    case '\u00ef': {
                        ca[i] = 9130;
                        nstate = 1;
                        break;
                    }
                    case '\u00f0': {
                        ca[i] = 63743;
                        nstate = 1;
                        break;
                    }
                    case '\u00f1': {
                        ca[i] = 12297;
                        nstate = 1;
                        break;
                    }
                    case '\u00f2': {
                        ca[i] = 8747;
                        nstate = 1;
                        break;
                    }
                    case '\u00f3': {
                        ca[i] = 8992;
                        nstate = 1;
                        break;
                    }
                    case '\u00f4': {
                        ca[i] = 9134;
                        nstate = 1;
                        break;
                    }
                    case '\u00f5': {
                        ca[i] = 8993;
                        nstate = 1;
                        break;
                    }
                    case '\u00f6': {
                        ca[i] = 9118;
                        nstate = 1;
                        break;
                    }
                    case '\u00f7': {
                        ca[i] = 9119;
                        nstate = 1;
                        break;
                    }
                    case '\u00f8': {
                        ca[i] = 9120;
                        nstate = 1;
                        break;
                    }
                    case '\u00f9': {
                        ca[i] = 9124;
                        nstate = 1;
                        break;
                    }
                    case '\u00fa': {
                        ca[i] = 9125;
                        nstate = 1;
                        break;
                    }
                    case '\u00fb': {
                        ca[i] = 9126;
                        nstate = 1;
                        break;
                    }
                    case '\u00fc': {
                        ca[i] = 9131;
                        nstate = 1;
                        break;
                    }
                    case '\u00fd': {
                        ca[i] = 9132;
                        nstate = 1;
                        break;
                    }
                    case '\u00fe': {
                        ca[i] = 9133;
                        nstate = 1;
                        break;
                    }
                    case '\u00ff': {
                        ca[i] = 8594;
                        nstate = 1;
                        break;
                    }
                    default: {
                        nstate = 0;
                    }
                }
                if (nstate == state) continue;
                if (start < i) {
                    Element span;
                    Text text = this.doc.createTextNode(String.valueOf(ca, start, i - start));
                    if (state == 0) {
                        elem.appendChild(text);
                    } else if (state == 1) {
                        span = this.doc.createElement("tspan");
                        span.setAttribute("font-family", "serif");
                        span.appendChild(text);
                        elem.appendChild(span);
                    } else if (state == 2) {
                        span = this.doc.createElement("tspan");
                        span.setAttribute("font-family", "sans-serif");
                        span.appendChild(text);
                        elem.appendChild(span);
                    }
                    start = i;
                }
                state = nstate;
            }
            if (start < ca.length) {
                Text text = this.doc.createTextNode(String.valueOf(ca, start, ca.length - start));
                if (state == 0) {
                    elem.appendChild(text);
                } else if (state == 1) {
                    Element span = this.doc.createElement("tspan");
                    span.setAttribute("font-family", "serif");
                    span.appendChild(text);
                    elem.appendChild(span);
                } else if (state == 2) {
                    Element span = this.doc.createElement("tspan");
                    span.setAttribute("font-family", "sans-serif");
                    span.appendChild(text);
                    elem.appendChild(span);
                }
            }
            return;
        }
        elem.appendChild(this.doc.createTextNode(str));
    }

    private void bmpToSvg(byte[] image, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, int usage, long rop) {
        String ropFilter;
        if (image == null || image.length == 0) {
            return;
        }
        if ((image = ImageUtil.convert(this.dibToBmp(image), "png", dh < 0)) == null || image.length == 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer("data:image/png;base64,");
        buffer.append(Base64.encode(image));
        String data = buffer.toString();
        if (data == null || data.equals("")) {
            return;
        }
        Element elem = this.doc.createElement("image");
        int x = (int)this.dc.toAbsoluteX(dx);
        int y = (int)this.dc.toAbsoluteY(dy);
        int width = (int)this.dc.toRelativeX(dw);
        int height = (int)this.dc.toRelativeY(dh);
        if (width < 0 && height < 0) {
            elem.setAttribute("transform", "scale(-1, -1) translate(" + -x + ", " + -y + ")");
        } else if (width < 0) {
            elem.setAttribute("transform", "scale(-1, 1) translate(" + -x + ", " + y + ")");
        } else if (height < 0) {
            elem.setAttribute("transform", "scale(1, -1) translate(" + x + ", " + -y + ")");
        } else {
            elem.setAttribute("x", "" + x);
            elem.setAttribute("y", "" + y);
        }
        elem.setAttribute("width", "" + Math.abs(width));
        elem.setAttribute("height", "" + Math.abs(height));
        if (sx != 0 || sy != 0 || sw != dw || sh != dh) {
            elem.setAttribute("viewBox", "" + sx + " " + sy + " " + sw + " " + sh);
            elem.setAttribute("preserveAspectRatio", "none");
        }
        if ((ropFilter = this.dc.getRopFilter(rop)) != null) {
            elem.setAttribute("filter", ropFilter);
        }
        elem.setAttribute("xlink:href", data);
        this.parentNode.appendChild(elem);
    }

    private byte[] dibToBmp(byte[] dib) {
        byte[] data = new byte[14 + dib.length];
        data[0] = 66;
        data[1] = 77;
        long bfSize = data.length;
        data[2] = (byte)(bfSize & 0xFFL);
        data[3] = (byte)(bfSize >> 8 & 0xFFL);
        data[4] = (byte)(bfSize >> 16 & 0xFFL);
        data[5] = (byte)(bfSize >> 24 & 0xFFL);
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        data[9] = 0;
        long bfOffBits = 14L;
        long biSize = (dib[0] & 0xFF) + ((dib[1] & 0xFF) << 8) + ((dib[2] & 0xFF) << 16) + ((dib[3] & 0xFF) << 24);
        bfOffBits += biSize;
        int biBitCount = (dib[14] & 0xFF) + ((dib[15] & 0xFF) << 8);
        long clrUsed = (dib[32] & 0xFF) + ((dib[33] & 0xFF) << 8) + ((dib[34] & 0xFF) << 16) + ((dib[35] & 0xFF) << 24);
        switch (biBitCount) {
            case 1: {
                bfOffBits += (clrUsed == 0L ? 2L : clrUsed) * 4L;
                break;
            }
            case 4: {
                bfOffBits += (clrUsed == 0L ? 16L : clrUsed) * 4L;
                break;
            }
            case 8: {
                bfOffBits += (clrUsed == 0L ? 256L : clrUsed) * 4L;
            }
        }
        data[10] = (byte)(bfOffBits & 0xFFL);
        data[11] = (byte)(bfOffBits >> 8 & 0xFFL);
        data[12] = (byte)(bfOffBits >> 16 & 0xFFL);
        data[13] = (byte)(bfOffBits >> 24 & 0xFFL);
        System.arraycopy(dib, 0, data, 14, dib.length);
        return data;
    }
}

