/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.IllegalCloseElementException;
import com.topologi.diffx.xml.UnclosedElementException;
import com.topologi.diffx.xml.UndeclaredNamespaceException;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLWriterNSImpl
extends XMLWriterBase
implements XMLWriter {
    protected static Logger log = LoggerFactory.getLogger(XMLWriterNSImpl.class);
    private static final PrefixMapping DEFAULT_NS = new PrefixMapping("", "");
    private static final Element ROOT;
    private final Map<String, String> prefixMapping = new HashMap<String, String>();
    private List<PrefixMapping> tempMapping;
    private final List<Element> elements = new ArrayList<Element>();

    public XMLWriterNSImpl(Writer writer) throws NullPointerException {
        this(writer, false);
    }

    public XMLWriterNSImpl(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
        this.prefixMapping.put("http://www.w3.org/XML/1998/namespace", "xml");
    }

    @Override
    void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.indent && this.peekElement().hasChildren) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    @Override
    public void openElement(String name) throws IOException {
        this.openElement(null, name, false);
    }

    public void openElement(String uri, String name) throws IOException {
        this.openElement(uri, name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws IOException {
        this.openElement(null, name, hasChildren);
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws IOException {
        this.deNude();
        this.indent();
        String qName = this.getQName(uri, name);
        this.elements.add(new Element(qName, hasChildren, this.tempMapping));
        this.writer.write(60);
        this.writer.write(qName);
        this.handleNamespaceDeclaration();
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void closeElement() throws IOException {
        Element elt = this.popElement();
        if (elt == ROOT) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int x = elt.qName.indexOf(32);
            if (x < 0) {
                this.writer.write(elt.qName);
            } else {
                this.writer.write(elt.qName.substring(0, x));
            }
        }
        this.restorePrefixMapping(elt);
        this.writer.write(62);
        if (this.indent) {
            Element parent = this.peekElement();
            if (parent.hasChildren && parent != ROOT) {
                this.writer.write(10);
            }
        }
    }

    @Override
    public void emptyElement(String element) throws IOException {
        this.emptyElement(null, element);
    }

    @Override
    public void emptyElement(String uri, String element) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(this.getQName(uri, element));
        this.handleNamespaceDeclaration();
        this.writer.write(47);
        this.writer.write(62);
        if (this.indent) {
            this.writer.write(10);
        }
    }

    private Element peekElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return this.elements.remove(this.elements.size() - 1);
    }

    @Override
    public void attribute(String uri, String name, String value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(uri, name));
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(value);
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    @Override
    public void attribute(String uri, String name, int value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(uri, name));
        this.writer.write("=\"");
        this.writer.write(Integer.toString(value));
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws NullPointerException {
        if (!prefix.equals(this.prefixMapping.get(uri))) {
            this.removeIfNeeded(prefix);
            PrefixMapping pm = new PrefixMapping(prefix, uri);
            this.prefixMapping.put(pm.uri, pm.prefix);
            if (log.isDebugEnabled()) {
                log.debug(pm.prefix + " -> " + pm.uri);
            }
            if (this.tempMapping == null) {
                this.tempMapping = new ArrayList<PrefixMapping>();
            }
            this.tempMapping.add(pm);
        }
    }

    private String getQName(String uri, String name) throws UndeclaredNamespaceException {
        String prefix = this.prefixMapping.get(uri != null ? uri : "");
        if (prefix != null) {
            if (!"".equals(prefix)) {
                return this.prefixMapping.get(uri) + ":" + name;
            }
            return name;
        }
        if (uri == null) {
            return name;
        }
        throw new UndeclaredNamespaceException(uri);
    }

    private void handleNamespaceDeclaration() throws IOException {
        if (this.tempMapping != null) {
            PrefixMapping pm = null;
            for (int i = 0; i < this.tempMapping.size(); ++i) {
                pm = this.tempMapping.get(i);
                if ("xml".equals(pm.prefix)) continue;
                this.writer.write(" xmlns");
                if (!"".equals(pm.prefix)) {
                    this.writer.write(58);
                    this.writer.write(pm.prefix);
                }
                this.writer.write("=\"");
                this.writer.write(pm.uri);
                this.writer.write("\"");
            }
            this.tempMapping = null;
        }
    }

    private void restorePrefixMapping(Element elt) {
        if (elt.mappings != null) {
            for (int i = 0; i < elt.mappings.size(); ++i) {
                PrefixMapping mpi = elt.mappings.get(i);
                if (log.isDebugEnabled()) {
                    log.debug(mpi.prefix + " -< ");
                }
                block1: for (int j = this.elements.size() - 1; j > 0; --j) {
                    if (this.elements.get((int)j).mappings == null) continue;
                    List<PrefixMapping> mps = this.elements.get((int)j).mappings;
                    for (int k = 0; k < mps.size(); ++k) {
                        PrefixMapping mpk = mps.get(k);
                        if (!mpk.prefix.equals(mpi.prefix)) continue;
                        this.removeIfNeeded(mpk.prefix);
                        this.prefixMapping.put(mpk.uri, mpk.prefix);
                        if (log.isDebugEnabled()) {
                            log.debug(mpk.uri + " [R]");
                        }
                        j = 0;
                        continue block1;
                    }
                }
            }
        }
    }

    private void removeIfNeeded(String prefix) {
        if (this.prefixMapping.containsValue(prefix)) {
            Map.Entry<String, String> remove = null;
            for (Map.Entry<String, String> e : this.prefixMapping.entrySet()) {
                if (!e.getValue().equals(prefix)) continue;
                remove = e;
                break;
            }
            this.prefixMapping.remove(remove.getKey());
        }
    }

    @Override
    public void close() throws IOException, UnclosedElementException {
        Element open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open.qName);
        }
        this.writer.close();
    }

    static {
        ArrayList<PrefixMapping> mps = new ArrayList<PrefixMapping>();
        mps.add(DEFAULT_NS);
        ROOT = new Element("", true, mps);
    }

    private static final class Element {
        private final String qName;
        private final boolean hasChildren;
        private final List<PrefixMapping> mappings;

        public Element(String qName, boolean hasChildren, List<PrefixMapping> mappings) {
            this.qName = qName;
            this.hasChildren = hasChildren;
            this.mappings = mappings;
        }
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix != null ? prefix : "";
            this.uri = uri != null ? uri : "";
        }
    }
}

