/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.config.TextGranularity;
import com.topologi.diffx.load.text.TextTokenizer;
import com.topologi.diffx.load.text.TokenizerByChar;
import com.topologi.diffx.load.text.TokenizerByText;
import com.topologi.diffx.load.text.TokenizerByWord;

public final class TokenizerFactory {
    private TokenizerFactory() {
    }

    public static TextTokenizer get(DiffXConfig config) {
        if (config == null) {
            throw new NullPointerException("The config should be specified");
        }
        TextGranularity granularity = config.getGranularity();
        switch (granularity) {
            case CHARACTER: {
                return new TokenizerByChar();
            }
            case WORD: {
                return new TokenizerByWord(config.getWhiteSpaceProcessing());
            }
            case TEXT: {
                return new TokenizerByText(config.getWhiteSpaceProcessing());
            }
        }
        throw new IllegalArgumentException("Unsupported text granularity " + granularity);
    }
}

