/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.CharactersEventBase;

public final class SpaceEvent
extends CharactersEventBase
implements TextEvent {
    public static final SpaceEvent SINGLE_WHITESPACE = new SpaceEvent(" ");
    public static final SpaceEvent DOUBLE_WHITESPACE = new SpaceEvent("  ");
    public static final SpaceEvent NEW_LINE = new SpaceEvent("\n");
    public static final SpaceEvent TAB = new SpaceEvent("\t");

    public SpaceEvent(CharSequence w) throws NullPointerException {
        super(w);
    }

    public String toString() {
        return "space: \"" + SpaceEvent.toString(this.getCharacters().toCharArray()) + "\"";
    }

    public static SpaceEvent getInstance(CharSequence space) {
        if (" ".equals(space)) {
            return SINGLE_WHITESPACE;
        }
        if ("  ".equals(space)) {
            return DOUBLE_WHITESPACE;
        }
        if ("\n".equals(space)) {
            return NEW_LINE;
        }
        if ("\t".equals(space)) {
            return TAB;
        }
        return new SpaceEvent(space);
    }

    public static SpaceEvent getInstance(char c) {
        if (c == ' ') {
            return SINGLE_WHITESPACE;
        }
        if (c == '\n') {
            return NEW_LINE;
        }
        if (c == '\t') {
            return TAB;
        }
        return new SpaceEvent("" + c);
    }

    private static String toString(char[] chars) {
        StringBuffer out = new StringBuffer();
        block4: for (char c : chars) {
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block4;
                }
                case '\t': {
                    out.append("\\t");
                    continue block4;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

