/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml.renderer;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceControlPriority;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.pdfboxout.PdfBoxImage;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.swing.NaiveUserAgent;
import com.openhtmltopdf.util.LogMessageId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Docx4jUserAgent
extends NaiveUserAgent {
    public static Logger log = LoggerFactory.getLogger(Docx4jUserAgent.class);

    protected byte[] readStream(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream(is.available());
        byte[] buf = new byte[10240];
        while ((i = is.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getImageResource(String uriStr, ExternalResourceType type) {
        if (!this.checkAccessAllowed(uriStr, type, ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI)) {
            return new ImageResource(uriStr, null);
        }
        String uriResolved = this.resolveURI(uriStr);
        if (uriResolved == null) {
            log.info("image " + LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI + uriStr);
            return new ImageResource(uriStr, null);
        }
        if (!this.checkAccessAllowed(uriResolved, type, ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI)) {
            return new ImageResource(uriStr, null);
        }
        ImageResource resource = (ImageResource)this._imageCache.get(uriResolved);
        if (resource != null && resource.getImage() instanceof PdfBoxImage) {
            PdfBoxImage original = (PdfBoxImage)resource.getImage();
            PdfBoxImage copy = new PdfBoxImage(original.getBytes(), original.getUri(), (float)original.getWidth(), (float)original.getHeight(), original.getXObject());
            return new ImageResource(resource.getImageUri(), (FSImage)copy);
        }
        InputStream is = this.openStream(uriResolved);
        if (is != null) {
            try {
                if (!uriStr.toLowerCase(Locale.US).endsWith(".pdf")) {
                    byte[] imgBytes = this.readStream(is);
                    PdfBoxImage fsImage = new PdfBoxImage(imgBytes, uriStr);
                    resource = new ImageResource(uriResolved, (FSImage)fsImage);
                }
                this._imageCache.put(uriResolved, resource);
            }
            catch (Exception e) {
                log.error(LogMessageId.LogMessageId1Param.EXCEPTION_CANT_READ_IMAGE_FILE_FOR_URI + uriStr, (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        resource = resource != null ? new ImageResource(resource.getImageUri(), resource.getImage()) : new ImageResource(uriStr, null);
        return resource;
    }
}

