/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml.dom;

import com.topologi.diffx.xml.IllegalCloseElementException;
import com.topologi.diffx.xml.dom.DOMWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.docx4j.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMWriterImpl
implements DOMWriter {
    private final Document document;
    private final Node newline;
    private boolean indent;
    private String indentChars;
    private transient int depth;
    private transient boolean isNude;
    private transient Node currentElement;
    private transient List<Boolean> childrenFlags = new ArrayList<Boolean>();

    public DOMWriterImpl() throws ParserConfigurationException {
        this(DOMWriterImpl.newDocument());
    }

    public DOMWriterImpl(Document document) {
        if (document == null) {
            throw new NullPointerException("The XMLWriter requires a DOM Document to write on.");
        }
        this.document = document;
        this.currentElement = document;
        this.newline = document.createTextNode("\n");
    }

    @Override
    public void xmlDecl() {
    }

    @Override
    public void setIndentChars(String spaces) {
        if (this.depth != 0) {
            throw new IllegalStateException("To late to set the indentation characters!");
        }
        if (spaces != null) {
            for (int i = 0; i < spaces.length(); ++i) {
                if (Character.isSpaceChar(spaces.charAt(i))) continue;
                throw new IllegalArgumentException("Not a valid indentation string.");
            }
        }
        this.indentChars = spaces;
        this.indent = spaces != null;
    }

    @Override
    public void writeText(String text) {
        if (text == null) {
            return;
        }
        this.deNude();
        Text textNode = this.document.createTextNode(text);
        this.currentElement.appendChild(textNode);
    }

    @Override
    public void writeText(char[] text, int off, int len) {
        this.writeText(new String(text, off, len));
    }

    @Override
    public void writeText(char c) {
        this.writeText(new String(new char[]{c}));
    }

    public void writeText(Object o) {
        if (o != null) {
            this.writeText(o.toString());
        }
    }

    @Override
    public void writeCDATA(String data) {
        if (data == null) {
            return;
        }
        this.document.createCDATASection(data);
    }

    @Override
    public void writeXML(String text) {
        throw new UnsupportedOperationException("Cannot use unparsed XML as DOM node.");
    }

    @Override
    public void writeXML(char[] text, int off, int len) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use unparsed XML as DOM node.");
    }

    @Override
    public void writeComment(String comment) throws DOMException {
        if (comment.indexOf("--") >= 0) {
            throw new IllegalArgumentException("A comment must not contain '--'.");
        }
        this.deNude();
        Comment node = this.document.createComment(comment);
        this.currentElement.appendChild(node);
        if (this.indent) {
            this.newLine();
        }
    }

    @Override
    public void writePI(String target, String data) throws DOMException {
        this.deNude();
        ProcessingInstruction node = this.document.createProcessingInstruction(target, data);
        this.currentElement.appendChild(node);
        if (this.indent) {
            this.newLine();
        }
    }

    @Override
    public void attribute(String name, String value) throws DOMException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        this.currentElement.appendChild(att);
    }

    @Override
    public void attribute(String name, int value) throws DOMException {
        this.attribute(name, Integer.toString(value));
    }

    @Override
    public void openElement(String name) throws DOMException {
        this.openElement(name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws DOMException {
        this.deNude();
        this.indent();
        this.childrenFlags.add(hasChildren);
        Element element = this.document.createElement(name);
        this.currentElement.appendChild(element);
        this.currentElement = element;
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void element(String name, String text) throws DOMException {
        this.openElement(name);
        this.writeText(text);
        this.closeElement();
    }

    @Override
    public void closeElement() throws DOMException, IllegalCloseElementException {
        Boolean b;
        if (this.currentElement.getNodeType() == 9) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        this.isNude = false;
        Boolean hasChildren = this.childrenFlags.remove(this.childrenFlags.size() - 1);
        if (hasChildren.booleanValue()) {
            this.indent();
        }
        this.currentElement.normalize();
        this.currentElement = (Element)this.currentElement.getParentNode();
        if (this.indent && (b = this.childrenFlags.get(this.childrenFlags.size() - 1)).booleanValue()) {
            this.newLine();
        }
    }

    @Override
    public void emptyElement(String name) throws DOMException {
        Element element = this.document.createElement(name);
        this.currentElement.appendChild(element);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
        this.currentElement.normalize();
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public void openElement(String uri, String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces.");
    }

    @Override
    public void emptyElement(String uri, String element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, String value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    @Override
    public void attribute(String uri, String name, int value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This class does not handle namespaces");
    }

    void indent() {
        if (this.indent) {
            StringBuffer out = new StringBuffer(this.depth * this.indentChars.length());
            for (int i = 0; i < this.depth; ++i) {
                out.append(this.indentChars);
            }
            Text node = this.document.createTextNode(out.toString());
            this.currentElement.appendChild(node);
        }
    }

    private void deNude() {
        if (this.isNude) {
            if (this.indent) {
                this.newLine();
            }
            this.isNude = false;
        }
    }

    private void newLine() {
        this.currentElement.appendChild(this.newline.cloneNode(false));
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilder builder = XmlUtils.getNewDocumentBuilder();
        return builder.newDocument();
    }
}

