/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.ws;

import com.documents4j.throwables.ConversionFormatException;
import com.documents4j.throwables.ConversionInputException;
import com.documents4j.util.Reaction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.ws.rs.core.Response;

public final class ConverterNetworkProtocol {
    public static final int CURRENT_PROTOCOL_VERSION = 1;
    public static final String RESOURCE_PATH = "/";
    public static final String HEADER_JOB_PRIORITY = "Converter-Job-Priority";
    public static final String COMPRESSION_TYPE_GZIP = "gzip";
    public static final String COMPRESSION_TYPE_XGZIP = "x-gzip";
    private static final int RESPONSE_STATUS_CODE_CANCEL = 530;
    private static final int RESPONSE_STATUS_CODE_TIMEOUT = 522;
    private static final int RESPONSE_STATUS_CODE_INPUT_ERROR = 422;

    private ConverterNetworkProtocol() {
        throw new UnsupportedOperationException();
    }

    public static enum Status {
        OK(Response.Status.OK.getStatusCode(), Reaction.with((boolean)true)),
        CANCEL(530, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConverterAccessExceptionBuilder("The conversion attempt was cancelled"))),
        TIMEOUT(522, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConverterAccessExceptionBuilder("The conversion attempt timed out"))),
        CONVERTER_ERROR(Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConverterAccessExceptionBuilder("The converter could not process the request"))),
        INPUT_ERROR(422, Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConversionInputExceptionBuilder("The sent input is invalid"))),
        FORMAT_ERROR(Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), Reaction.with((Reaction.IExceptionBuilder)new Reaction.ConversionFormatExceptionBuilder("The given input/output format combination is not supported"))),
        UNKNOWN(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), Reaction.with((boolean)false));

        private final Integer statusCode;
        private final Reaction reaction;

        private Status(Integer statusCode, Reaction reaction) {
            this.statusCode = statusCode;
            this.reaction = reaction;
        }

        public static Status from(int statusCode) {
            for (Status status : Status.values()) {
                if (!Objects.equal((Object)statusCode, (Object)status.getStatusCode())) continue;
                return status;
            }
            return UNKNOWN;
        }

        public static Status describe(Exception e) {
            if (e instanceof ConversionInputException) {
                return INPUT_ERROR;
            }
            if (e instanceof ConversionFormatException) {
                return FORMAT_ERROR;
            }
            return CONVERTER_ERROR;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public boolean resolve() {
            return this.reaction.apply();
        }

        public String toString() {
            return MoreObjects.toStringHelper(Status.class).add("statusCode", (Object)this.statusCode).add("reaction", (Object)this.reaction).toString();
        }
    }
}

