/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.job;

import com.documents4j.api.IFileSource;
import com.documents4j.api.IInputStreamSource;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileSourceFromInputStreamSource
implements IFileSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSourceFromInputStreamSource.class);
    private final IInputStreamSource inputStreamSource;
    private final File tempStorage;
    private InputStream inputStream;

    public FileSourceFromInputStreamSource(IInputStreamSource inputStreamSource, File tempStorage) {
        this.inputStreamSource = inputStreamSource;
        this.tempStorage = tempStorage;
    }

    public File getFile() {
        File file;
        this.inputStream = this.inputStreamSource.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(this.tempStorage);
        fileOutputStream.getChannel().lock();
        try {
            ByteStreams.copy((InputStream)this.inputStream, (OutputStream)fileOutputStream);
            file = this.tempStorage;
        }
        catch (Throwable throwable) {
            try {
                Closeables.close((Closeable)fileOutputStream, (boolean)true);
                throw throwable;
            }
            catch (IOException e) {
                throw new FileSystemInteractionException(String.format("Could not write stream to file %s", this.tempStorage), (Throwable)e);
            }
        }
        Closeables.close((Closeable)fileOutputStream, (boolean)true);
        return file;
    }

    public void onConsumed(File file) {
        try {
            if (!this.tempStorage.delete()) {
                LOGGER.warn("Could not delete temporary file {}", (Object)this.tempStorage);
            }
        }
        finally {
            this.inputStreamSource.onConsumed(this.inputStream);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(FileSourceFromInputStreamSource.class).add("inputStreamSource", (Object)this.inputStreamSource).add("temporaryFile", (Object)this.tempStorage).toString();
    }
}

