/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import com.openhtmltopdf.css.parser.PropertyValue;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.docx4j.convert.in.xhtml.ImportXHTMLProperties;
import org.docx4j.fonts.microsoft.MicrosoftFontsRegistry;
import org.docx4j.jaxb.Context;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontHandler {
    public static Logger log = LoggerFactory.getLogger(FontHandler.class);
    private static FontFamilyMap fontFamilyToFont = new FontFamilyMap();
    private static Map<String, RFonts> fontFamiliesToFont;

    protected static void addFontMapping(String cssFontFamily, RFonts rFonts) {
        fontFamilyToFont.put(cssFontFamily, rFonts);
    }

    protected static void addFontMapping(String cssFontFamily, String font) {
        RFonts rFonts = Context.getWmlObjectFactory().createRFonts();
        rFonts.setAscii(font);
        rFonts.setHAnsi(font);
        FontHandler.addFontMapping(cssFontFamily, rFonts);
    }

    protected static RFonts getRFonts(String cssFontFamily) {
        return fontFamilyToFont.get(cssFontFamily);
    }

    protected static void setRFont(PropertyValue fontFamily, RPr rpr) {
        if (fontFamily == null) {
            return;
        }
        RFonts rfonts = fontFamiliesToFont.get(fontFamily.getCssText());
        if (rfonts != null) {
            rpr.setRFonts(rfonts);
            return;
        }
        StringTokenizer st = new StringTokenizer(fontFamily.getCssText(), ",");
        while (st.hasMoreTokens()) {
            String thisFontFamily = st.nextToken().trim();
            thisFontFamily = thisFontFamily.replace("'", "");
            RFonts mappedTo = FontHandler.getRFonts(thisFontFamily = thisFontFamily.replace("\"", ""));
            if (mappedTo == null) {
                log.warn("No mapping for: '" + thisFontFamily + "'");
                continue;
            }
            rpr.setRFonts(mappedTo);
            fontFamiliesToFont.put(fontFamily.getCssText(), mappedTo);
            return;
        }
    }

    static {
        FontHandler.addFontMapping("serif", ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.fonts.default.serif", "Times New Roman"));
        FontHandler.addFontMapping("sans-serif", ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.fonts.default.sans-serif", "Arial"));
        FontHandler.addFontMapping("monospace", ImportXHTMLProperties.getProperty("docx4j-ImportXHTML.fonts.default.monospace", "Courier New"));
        Map msFontsByName = MicrosoftFontsRegistry.getMsFonts();
        for (String cssFontFamily : msFontsByName.keySet()) {
            FontHandler.addFontMapping(cssFontFamily, cssFontFamily);
        }
        fontFamiliesToFont = new HashMap<String, RFonts>();
    }

    static class FontFamilyMap
    extends HashMap<String, RFonts> {
        FontFamilyMap() {
        }

        @Override
        public RFonts put(String key, RFonts value) {
            return super.put(key.toLowerCase(), value);
        }

        public RFonts get(String key) {
            return (RFonts)super.get(key.toLowerCase());
        }
    }
}

